/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified.leaves.bool;

import choco.cp.solver.constraints.integer.bool.BooleanFactory;
import choco.cp.solver.constraints.integer.channeling.ReifiedBinXnor;
import choco.cp.solver.constraints.reified.leaves.bool.AbstractBoolNode;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.reified.BoolNode;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.constraints.reified.NodeType;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class XnorNode
extends AbstractBoolNode
implements BoolNode {
    public XnorNode(INode ... subt) {
        super(subt, NodeType.XNOR);
    }

    @Override
    public boolean checkTuple(int[] tuple) {
        return tuple[0] == tuple[1];
    }

    @Override
    public IntDomainVar extractResult(Solver s) {
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        if (vs.length == 1) {
            IntDomainVar v = s.createBooleanVar(StringUtils.randomName());
            s.post(new ReifiedBinXnor(v, vs[0], vs[1]));
            return v;
        }
        return vs[0];
    }

    @Override
    public SConstraint extractConstraint(Solver s) {
        IntDomainVar[] vs = new IntDomainVar[this.subtrees.length];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = this.subtrees[i].extractResult(s);
        }
        return BooleanFactory.xor(vs);
    }

    @Override
    public boolean isReified() {
        return true;
    }

    @Override
    public String pretty() {
        int i;
        StringBuffer st = new StringBuffer("(");
        for (i = 0; i < this.subtrees.length - 1; ++i) {
            st.append(this.subtrees[i].pretty()).append(" xnor ");
        }
        st.append(this.subtrees[i].pretty()).append(")");
        return st.toString();
    }
}

