/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.integer;

import choco.cp.model.managers.MixedConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.integer.MaxOfAList;
import choco.cp.solver.constraints.integer.MaxXYZ;
import choco.cp.solver.constraints.integer.MinOfAList;
import choco.cp.solver.constraints.integer.MinXYZ;
import choco.cp.solver.constraints.set.AbstractBoundOfASet;
import choco.cp.solver.constraints.set.MaxOfASet;
import choco.cp.solver.constraints.set.MinOfASet;
import choco.kernel.common.util.tools.VariableUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.set.SetVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetVar;
import java.util.List;

public final class MinMaxManager
extends MixedConstraintManager {
    public SConstraint makeConstraint(Solver solver, Variable[] variables, Object parameters, List<String> options) {
        if (solver instanceof CPSolver && parameters instanceof Boolean) {
            return this.buildConstraint(solver, variables, (Boolean)parameters, options, null);
        }
        return null;
    }

    @Override
    public SConstraint[] makeConstraintAndOpposite(Solver solver, Variable[] variables, Object parameters, List<String> options) {
        if (solver instanceof CPSolver) {
            SConstraint[] cs = new SConstraint[2];
            if (parameters instanceof Boolean) {
                IntDomainVar X = solver.getVar((IntegerVariable)variables[0]);
                IntDomainVar Y = X.hasBooleanDomain() ? solver.createBooleanVar("Y_opp") : (X.hasEnumeratedDomain() ? solver.createEnumIntVar("Y_opp", X.getInf(), X.getSup()) : solver.createBoundIntVar("Y_opp", X.getInf(), X.getSup()));
                solver.post(this.buildConstraint(solver, variables, (Boolean)parameters, options, Y));
                cs[0] = solver.eq((IntExp)Y, (IntExp)X);
                cs[1] = solver.neq((IntExp)Y, (IntExp)X);
                return cs;
            }
        }
        return null;
    }

    public SConstraint buildConstraint(Solver solver, Variable[] variables, Boolean parameter, List<String> options, IntDomainVar varM) {
        IEnvironment environment = solver.getEnvironment();
        if (variables[0] instanceof SetVariable) {
            SetVar svar = solver.getVar((SetVariable)variables[0]);
            IntDomainVar[] ivars = VariableUtils.getIntVar(solver, variables, 1, variables.length);
            if (varM != null) {
                ivars[0] = varM;
            }
            AbstractBoundOfASet.EmptySetPolicy emptySetPolicy = options.contains("cp:min-max:inf") ? AbstractBoundOfASet.EmptySetPolicy.INF : (options.contains("cp:min-max:sup") ? AbstractBoundOfASet.EmptySetPolicy.SUP : AbstractBoundOfASet.EmptySetPolicy.NONE);
            return parameter != false ? new MinOfASet(environment, ivars, svar, emptySetPolicy) : new MaxOfASet(environment, ivars, svar, emptySetPolicy);
        }
        IntDomainVar[] ivars = VariableUtils.getIntVar(solver, variables, 0, variables.length);
        if (varM != null) {
            ivars[0] = varM;
        }
        if (ivars.length == 2) {
            return solver.eq((IntExp)ivars[0], (IntExp)ivars[1]);
        }
        if (ivars.length == 3) {
            return parameter != false ? new MinXYZ(ivars[1], ivars[2], ivars[0]) : new MaxXYZ(ivars[1], ivars[2], ivars[0]);
        }
        return parameter != false ? new MinOfAList(environment, ivars) : new MaxOfAList(environment, ivars);
    }
}

