/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree;

import dr.evolution.coalescent.IntervalList;
import dr.evolution.coalescent.IntervalType;
import dr.evolution.util.Units;
import dr.evomodel.bigfasttree.BigFastTreeIntervals;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.Arrays;

public class ModelCompressedBigFastTreeIntervals
extends AbstractModel
implements Units,
IntervalList {
    private Units.Type units = Units.Type.GENERATIONS;
    private double[] startTimes;
    private double[] waitTimes;
    private int[] coalescentCounts;
    private int sampleCountAt0;
    private int[] sampleCounts;
    private int[] lineageCounts;
    private IntervalType[] types;
    private boolean intervalsKnown;
    private boolean storedIntervalsKnown;
    private boolean onlyUpdateTimes;
    private boolean storedOnlyUpdateTimes;
    private boolean dirty;
    private int intervalCount = 0;
    private BigFastTreeIntervals treeIntervals;
    private double[] modelIntervals;
    private double epsilon;

    public ModelCompressedBigFastTreeIntervals(BigFastTreeIntervals bigFastTreeIntervals, double[] dArray, double d) {
        super("modelCompressedBigFastIntervals");
        this.treeIntervals = bigFastTreeIntervals;
        this.modelIntervals = dArray;
        this.epsilon = d;
        int n = bigFastTreeIntervals.getIntervalCount();
        this.addModel(bigFastTreeIntervals);
        this.calculateIntervals();
    }

    @Override
    public int getIntervalCount() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.intervalCount;
    }

    @Override
    public int getSampleCount() {
        return this.treeIntervals.getSampleCount();
    }

    @Override
    public double getStartTime() {
        return this.treeIntervals.getStartTime();
    }

    @Override
    public double getInterval(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.waitTimes[n];
    }

    @Override
    public double getIntervalTime(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.startTimes[n];
    }

    @Override
    public int getLineageCount(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.lineageCounts[n];
    }

    public int getSampleEvents(int n) {
        if (n < 0) {
            return this.sampleCountAt0;
        }
        return this.sampleCounts[n];
    }

    @Override
    public int getCoalescentEvents(int n) {
        return this.coalescentCounts[n];
    }

    @Override
    public IntervalType getIntervalType(int n) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.types[n];
    }

    @Override
    public double getTotalDuration() {
        return this.treeIntervals.getTotalDuration();
    }

    @Override
    public boolean isBinaryCoalescent() {
        return false;
    }

    @Override
    public boolean isCoalescentOnly() {
        return false;
    }

    @Override
    public void calculateIntervals() {
        double d;
        double[] dArray = new double[this.treeIntervals.getIntervalCount()];
        double[] dArray2 = new double[this.treeIntervals.getIntervalCount()];
        int[] nArray = new int[this.treeIntervals.getIntervalCount()];
        int[] nArray2 = new int[this.treeIntervals.getIntervalCount()];
        int[] nArray3 = new int[this.treeIntervals.getIntervalCount()];
        int n = 0;
        int n2 = 0;
        double d2 = this.treeIntervals.getIntervalTime(n2);
        double d3 = d2 + (d = this.treeIntervals.getInterval(n2));
        if (d3 < this.epsilon) {
            while (d3 < this.epsilon) {
                ++n;
                d2 = this.treeIntervals.getIntervalTime(n2);
                d = this.treeIntervals.getInterval(n2);
                d3 = d2 + d;
                ++n2;
            }
            this.sampleCountAt0 = n;
            --n2;
        } else {
            n = 1;
            this.sampleCountAt0 = 1;
            n2 = 0;
        }
        double d4 = this.modelIntervals[0];
        dArray2[0] = this.treeIntervals.getStartTime();
        int n3 = 0;
        int n4 = -1;
        for (int i = n2; i < this.treeIntervals.getIntervalCount(); ++i) {
            d2 = this.treeIntervals.getIntervalTime(i);
            d3 = d2 + (d = this.treeIntervals.getInterval(i));
            if (Math.abs(d3 - d4) < this.epsilon) {
                d3 = d4;
                if (Math.abs(d2 - d4) < this.epsilon) {
                    d = 0.0;
                }
            }
            if (d3 > d4) {
                d4 = this.modelIntervals[++n3];
            }
            if (d > 0.0) {
                dArray2[++n4] = d2;
                dArray[n4] = d;
            }
            if (this.treeIntervals.getIntervalType(i) == IntervalType.SAMPLE) {
                ++n;
                int n5 = n4;
                nArray3[n5] = nArray3[n5] + 1;
            } else if (this.treeIntervals.getIntervalType(i) == IntervalType.COALESCENT) {
                int n6 = n4;
                nArray2[n6] = nArray2[n6] + 1;
                --n;
            }
            nArray[n4] = n + nArray2[n4] - nArray3[n4];
        }
        this.intervalCount = n4 + 1;
        this.intervalsKnown = true;
        this.startTimes = Arrays.copyOf(dArray2, this.intervalCount);
        this.waitTimes = Arrays.copyOf(dArray, this.intervalCount);
        this.lineageCounts = Arrays.copyOf(nArray, this.intervalCount);
        this.coalescentCounts = Arrays.copyOf(nArray2, this.intervalCount);
        this.sampleCounts = Arrays.copyOf(nArray3, this.intervalCount);
    }

    @Override
    public final Units.Type getUnits() {
        return this.units;
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.units = type;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

