/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import org.freehep.graphicsio.font.truetype.TTFCMapTable;
import org.freehep.graphicsio.font.truetype.TTFFont;
import org.freehep.graphicsio.font.truetype.TTFGlyfTable;
import org.freehep.graphicsio.font.truetype.TTFHHeaTable;
import org.freehep.graphicsio.font.truetype.TTFHMtxTable;
import org.freehep.graphicsio.font.truetype.TTFHeadTable;
import org.freehep.graphicsio.font.truetype.TTFInput;
import org.freehep.graphicsio.font.truetype.TTFLocaTable;
import org.freehep.graphicsio.font.truetype.TTFMaxPTable;
import org.freehep.graphicsio.font.truetype.TTFNameTable;
import org.freehep.graphicsio.font.truetype.TTFOS_2Table;
import org.freehep.graphicsio.font.truetype.TTFPostTable;

public abstract class TTFTable {
    public static final String[] TT_TAGS = new String[]{"cmap", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "name", "OS/2", "post"};
    public static final Class<?>[] TABLE_CLASSES = new Class[]{TTFCMapTable.class, TTFGlyfTable.class, TTFHeadTable.class, TTFHHeaTable.class, TTFHMtxTable.class, TTFLocaTable.class, TTFMaxPTable.class, TTFNameTable.class, TTFOS_2Table.class, TTFPostTable.class};
    private TTFFont ttfFont;
    TTFInput ttf;
    private boolean isRead = false;

    public void init(TTFFont font, TTFInput ttf) throws IOException {
        this.ttfFont = font;
        this.ttf = ttf;
    }

    public void read() throws IOException {
        this.ttf.pushPos();
        this.ttf.seek(0L);
        this.readTable();
        this.isRead = true;
        this.ttf.popPos();
    }

    public abstract void readTable() throws IOException;

    public abstract String getTag();

    public boolean isRead() {
        return this.isRead;
    }

    public TTFTable getTable(String tag) throws IOException {
        return this.ttfFont.getTable(tag);
    }

    public String toString() {
        return this.ttf + ": [" + this.getTag() + "/" + this.getClass().getName() + "]";
    }
}

