/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.file_chooser;

import java.io.File;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class DefaultFileView
extends FileView {
    protected Hashtable<File, Icon> iconCache = new Hashtable();
    protected Icon directoryIcon = UIManager.getIcon("FileView.directoryIcon");
    protected Icon fileIcon = UIManager.getIcon("FileView.fileIcon");
    protected Icon computerIcon = UIManager.getIcon("FileView.computerIcon");
    protected Icon hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
    protected Icon floppyDriveIcon = UIManager.getIcon("FileView.floppyDriveIcon");
    protected Icon newFolderIcon = UIManager.getIcon("FileChooser.newFolderIcon");
    protected Icon upFolderIcon = UIManager.getIcon("FileChooser.upFolderIcon");
    protected Icon homeFolderIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
    protected Icon listViewIcon = null;
    protected Icon detailsViewIcon = UIManager.getIcon("FileChooser.detailsViewIcon");
    protected String fileDescriptionText = "";
    protected String directoryDescriptionText = "";

    public DefaultFileView() {
        this.listViewIcon = UIManager.getIcon("FileChooser.listViewIcon");
        Locale locale = Locale.getDefault();
        this.fileDescriptionText = UIManager.getString((Object)"FileChooser.fileDescriptionText", locale);
        this.directoryDescriptionText = UIManager.getString((Object)"FileChooser.directoryDescriptionText", locale);
    }

    public void clearIconCache() {
        this.iconCache = new Hashtable();
    }

    @Override
    public String getName(File file) {
        String string = null;
        if (file != null) {
            string = FileSystemView.getFileSystemView().getSystemDisplayName(file);
        }
        return string;
    }

    @Override
    public String getDescription(File file) {
        return file.getName();
    }

    @Override
    public String getTypeDescription(File file) {
        String string = FileSystemView.getFileSystemView().getSystemTypeDescription(file);
        if (string == null) {
            string = file.isDirectory() ? this.directoryDescriptionText : this.fileDescriptionText;
        }
        return string;
    }

    public Icon getCachedIcon(File file) {
        return this.iconCache.get(file);
    }

    public void cacheIcon(File file, Icon icon) {
        if (file == null || icon == null) {
            return;
        }
        this.iconCache.put(file, icon);
    }

    @Override
    public Icon getIcon(File file) {
        Icon icon = this.getCachedIcon(file);
        if (icon != null) {
            return icon;
        }
        icon = this.fileIcon;
        if (file != null) {
            FileSystemView fileSystemView = FileSystemView.getFileSystemView();
            if (fileSystemView.isFloppyDrive(file)) {
                icon = this.floppyDriveIcon;
            } else if (fileSystemView.isDrive(file)) {
                icon = this.hardDriveIcon;
            } else if (fileSystemView.isComputerNode(file)) {
                icon = this.computerIcon;
            } else if (file.isDirectory()) {
                icon = this.directoryIcon;
            }
        }
        this.cacheIcon(file, icon);
        return icon;
    }

    public Boolean isHidden(File file) {
        String string = file.getName();
        if (string != null && string.charAt(0) == '.') {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

