/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class ResizableContainer
extends JPanel {
    private Component mComp;
    private int scale = 1;

    public ResizableContainer(Component component) {
        this(component, true);
    }

    public ResizableContainer(Component component, boolean bl) {
        this.mComp = component;
        if (bl) {
            Border border = BorderFactory.createBevelBorder(1);
            EmptyBorder emptyBorder = new EmptyBorder(10, 10, 10, 10);
            CompoundBorder compoundBorder = new CompoundBorder(emptyBorder, border);
            this.setBorder(compoundBorder);
        }
        this.setLayout(new BorderLayout());
        this.add(component, "Center");
        this.setOpaque(true);
    }

    public void setScale(int n) {
        if (n > 0) {
            this.scale = n;
            this.invalidate();
            Container container = this.getParent();
            if (container != null) {
                while (container.getParent() != null) {
                    container = container.getParent();
                }
                container.validate();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width *= this.scale;
        dimension.height *= this.scale;
        return dimension;
    }
}

