/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.lookandfeel;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class ExtendedTreeUI
extends BasicTreeUI {
    public ExtendedTreeUI(JTree jTree) {
        this.tree = jTree;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (jComponent instanceof JTree) {
            return new ExtendedTreeUI((JTree)jComponent);
        }
        return BasicTreeUI.createUI(jComponent);
    }

    @Override
    protected MouseListener createMouseListener() {
        return new TreeMouseHandler();
    }

    protected class TreeMouseHandler
    implements MouseInputListener {
        private int indexOnPress = -1;
        private MouseEvent dndArmedEvent = null;
        private int motionThreshold;
        private boolean checkedMotionThreshold = false;

        protected TreeMouseHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.shouldIgnore2(mouseEvent)) {
                return;
            }
            if (this.dndArmedEvent != null) {
                int n = this.mapDragOperationFromModifiers(mouseEvent);
                if (n == 0) {
                    return;
                }
                int n2 = Math.abs(mouseEvent.getX() - this.dndArmedEvent.getX());
                int n3 = Math.abs(mouseEvent.getY() - this.dndArmedEvent.getY());
                if (n2 > this.getMotionThreshold() || n3 > this.getMotionThreshold()) {
                    JComponent jComponent = this.getComponent(mouseEvent);
                    TransferHandler transferHandler = jComponent.getTransferHandler();
                    transferHandler.exportAsDrag(jComponent, this.dndArmedEvent, n);
                    this.dndArmedEvent = null;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TreePath treePath = ExtendedTreeUI.this.getClosestPathForLocation(ExtendedTreeUI.this.tree, mouseEvent.getX(), mouseEvent.getY());
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                ExtendedTreeUI.this.checkForClickInExpandControl(treePath, mouseEvent.getX(), mouseEvent.getY());
            }
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            this.indexOnPress = ExtendedTreeUI.this.tree.getRowForPath(treePath);
            if (this.indexOnPress > -1) {
                this.dndArmedEvent = mouseEvent;
                if (!ExtendedTreeUI.this.tree.hasFocus() && ExtendedTreeUI.this.tree.isRequestFocusEnabled()) {
                    ExtendedTreeUI.this.tree.requestFocus();
                }
                switch (ExtendedTreeUI.this.tree.getSelectionModel().getSelectionMode()) {
                    case 0: {
                        ExtendedTreeUI.this.tree.getSelectionModel().setSelectionPath(treePath);
                        break;
                    }
                    default: {
                        if (mouseEvent.isControlDown()) {
                            ExtendedTreeUI.this.tree.getSelectionModel().addSelectionPath(treePath);
                            break;
                        }
                        ExtendedTreeUI.this.tree.getSelectionModel().setSelectionPath(treePath);
                        break;
                    }
                }
            } else {
                this.dndArmedEvent = null;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        private int getMotionThreshold() {
            if (this.checkedMotionThreshold) {
                return this.motionThreshold;
            }
            this.checkedMotionThreshold = true;
            try {
                this.motionThreshold = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
            }
            catch (Exception exception) {
                this.motionThreshold = 5;
            }
            return this.motionThreshold;
        }

        protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                JComponent jComponent = this.getComponent(mouseEvent);
                TransferHandler transferHandler = jComponent.getTransferHandler();
                return transferHandler.getSourceActions(jComponent);
            }
            return 0;
        }

        protected JComponent getComponent(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                return jComponent;
            }
            return null;
        }

        private boolean shouldIgnore(MouseEvent mouseEvent) {
            return mouseEvent.isConsumed() || !ExtendedTreeUI.this.tree.isEnabled();
        }

        private boolean shouldIgnore2(MouseEvent mouseEvent) {
            return mouseEvent.isConsumed() || !ExtendedTreeUI.this.tree.getDragEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent) || !ExtendedTreeUI.this.tree.isEnabled();
        }
    }
}

