/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff;

import com.qarks.util.files.diff.FileLine;
import java.util.ArrayList;

public class MergeResultItem {
    private ArrayList<FileLine> leftVersion;
    private ArrayList<FileLine> rightVersion;
    private DefaultVersion defaultVersion;
    private Type type;
    private int lineCount;

    public MergeResultItem(Type type, ArrayList<FileLine> arrayList, ArrayList<FileLine> arrayList2, DefaultVersion defaultVersion, int n) {
        this.type = type;
        this.leftVersion = arrayList;
        this.rightVersion = arrayList2;
        this.defaultVersion = defaultVersion;
        this.lineCount = n;
    }

    public String toString() {
        String string = "# " + FileLine.statusToString(this.leftVersion.get(0).getStatus()) + "," + FileLine.statusToString(this.rightVersion.get(0).getStatus());
        return string;
    }

    public boolean couldMerge(MergeResultItem mergeResultItem) {
        boolean bl = false;
        if (this.leftVersion.get(this.lineCount - 1).getStatus() == mergeResultItem.leftVersion.get(mergeResultItem.lineCount - 1).getStatus() || this.rightVersion.get(this.lineCount - 1).getStatus() == mergeResultItem.rightVersion.get(mergeResultItem.lineCount - 1).getStatus()) {
            bl = true;
        }
        return bl;
    }

    public boolean isConflict() {
        return this.type == Type.CONFLICT;
    }

    public boolean matches() {
        boolean bl = false;
        if (this.leftVersion.get(0).getStatus() == 1 && this.rightVersion.get(0).getStatus() == 1) {
            bl = true;
        }
        return bl;
    }

    public static MergeResultItem merge(Type type, ArrayList<MergeResultItem> arrayList) {
        MergeResultItem mergeResultItem = new MergeResultItem(type, null, null, DefaultVersion.LEFT, 0);
        mergeResultItem.leftVersion = new ArrayList();
        mergeResultItem.rightVersion = new ArrayList();
        for (MergeResultItem mergeResultItem2 : arrayList) {
            mergeResultItem.leftVersion.addAll(mergeResultItem2.leftVersion);
            mergeResultItem.rightVersion.addAll(mergeResultItem2.rightVersion);
            mergeResultItem.lineCount += mergeResultItem2.lineCount;
        }
        return mergeResultItem;
    }

    public void mergeWith(MergeResultItem mergeResultItem) {
        this.leftVersion.addAll(mergeResultItem.leftVersion);
        this.rightVersion.addAll(mergeResultItem.rightVersion);
        this.lineCount += mergeResultItem.lineCount;
    }

    public ArrayList<FileLine> getLeftVersion() {
        return this.leftVersion;
    }

    public ArrayList<FileLine> getRightVersion() {
        return this.rightVersion;
    }

    public DefaultVersion getDefaultVersion() {
        return this.defaultVersion;
    }

    public Type getType() {
        return this.type;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public static enum DefaultVersion {
        LEFT,
        RIGHT;

    }

    public static enum Type {
        NO_CONFLICT,
        CONFLICT,
        WARNING_DELETE,
        WARNING_ORDER;

    }
}

