/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common;

import java.lang.reflect.Array;

public class HashCoding {
    public static final int SEED = 23;
    private static final int fODD_PRIME_NUMBER = 37;

    private static int hash(int aSeed, boolean aBoolean) {
        return HashCoding.firstTerm(aSeed) + (aBoolean ? 1 : 0);
    }

    private static int hash(int aSeed, char aChar) {
        return HashCoding.firstTerm(aSeed) + aChar;
    }

    private static int hash(int aSeed, int aInt) {
        return HashCoding.firstTerm(aSeed) + aInt;
    }

    private static int hash(int aSeed, long aLong) {
        return HashCoding.firstTerm(aSeed) + (int)(aLong ^ aLong >>> 32);
    }

    private static int hash(int aSeed, float aFloat) {
        return HashCoding.hash(aSeed, Float.floatToIntBits(aFloat));
    }

    private static int hash(int aSeed, double aDouble) {
        return HashCoding.hash(aSeed, Double.doubleToLongBits(aDouble));
    }

    private static int hash(int aSeed, Object aObject) {
        int result = aSeed;
        if (aObject == null) {
            result = HashCoding.hash(result, 0);
        } else if (!HashCoding.isArray(aObject)) {
            result = HashCoding.hash(result, aObject.hashCode());
        } else {
            int length = Array.getLength(aObject);
            for (int idx = 0; idx < length; ++idx) {
                Object item = Array.get(aObject, idx);
                result = HashCoding.hash(result, item);
            }
        }
        return result;
    }

    private static int firstTerm(int aSeed) {
        return 37 * aSeed;
    }

    private static boolean isArray(Object aObject) {
        return aObject.getClass().isArray();
    }

    public static int hashCodeMe(Object field) {
        return HashCoding.hashCodeMe(new Object[]{field});
    }

    public static int hashCodeMe(Object[] fields) {
        int result = 23;
        for (int field = 0; field < fields.length; ++field) {
            result = HashCoding.hash(result, field);
        }
        return result;
    }

    public static int hashCodeMe(long field) {
        return HashCoding.hash(23, field);
    }
}

