## -----------------------------------------------------------------------------
library(causalsens)
data(lalonde.exp)

## -----------------------------------------------------------------------------
ymodel <- lm(re78 ~ treat+age + education + black + hispanic + married +
             nodegree + re74 + re75 + u74 + u75, data = lalonde.exp)
summary(ymodel)

## -----------------------------------------------------------------------------
pmodel <- glm(treat ~ age + education + black + hispanic + married +
              nodegree + re74 + re75 + u74 + u75, data = lalonde.exp,
              family = binomial())
summary(pmodel)

## -----------------------------------------------------------------------------
alpha <- seq(-4500, 4500, by = 250)
ll.sens <- causalsens(ymodel, pmodel, ~ age + education, data = lalonde.exp,
                      alpha = alpha, confound = one.sided.att)

## -----------------------------------------------------------------------------
#  par(mfrow=c(1,2))
#  plot(ll.sens, type = "raw", bty = "n")
#  plot(ll.sens, type = "r.squared", bty = "n")

## -----------------------------------------------------------------------------
par(mfrow=c(1,2))
plot(ll.sens, type = "raw", bty = "n")
plot(ll.sens, type = "r.squared", bty = "n")

