/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.tan;

import java.util.Comparator;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.base.AbstractEvaluator;
import net.sourceforge.jclec.fitness.SimpleValueFitness;
import net.sourceforge.jclec.fitness.ValueFitnessComparator;
import net.sourceforge.jclec.problem.classification.Individual;
import net.sourceforge.jclec.problem.classification.SyntaxTreeClassificationRule;
import net.sourceforge.jclec.util.dataset.IDataset;
import net.sourceforge.jclec.util.dataset.IMetadata;
import net.sourceforge.jclec.util.random.IRandGen;
import org.apache.commons.configuration.Configuration;

public class TanEvaluator
extends AbstractEvaluator
implements IConfigure {
    private static final long serialVersionUID = 3613350191235561000L;
    protected SyntaxTreeClassificationRule rule;
    protected IDataset dataset;
    private boolean maximize = true;
    protected IRandGen randgen;
    protected int maxDerivSize;
    protected int classifiedClass;
    protected float w1;
    protected float w2;
    protected transient ValueFitnessComparator comparator;

    public IDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(IDataset dataset) {
        this.dataset = dataset;
    }

    public void setRandGen(IRandGen randgen) {
        this.randgen = randgen;
    }

    public IRandGen getRandGen() {
        return this.randgen;
    }

    public int getMaxDerivSize() {
        return this.maxDerivSize;
    }

    public void setMaxDerivSize(int maxDerivSize) {
        this.maxDerivSize = maxDerivSize;
    }

    public float getW1() {
        return this.w1;
    }

    public void setW1(float w1) {
        this.w1 = w1;
    }

    public float getW2() {
        return this.w2;
    }

    public void setW2(float w2) {
        this.w2 = w2;
    }

    public void setClassifiedClass(int classifiedClass) {
        this.classifiedClass = classifiedClass;
    }

    public int getClassifiedClass() {
        return this.classifiedClass;
    }

    @Override
    public void configure(Configuration settings) {
        float w1 = settings.getFloat("w1");
        this.setW1(w1);
        float w2 = settings.getFloat("w2");
        this.setW2(w2);
    }

    @Override
    protected void evaluate(IIndividual ind) {
        Individual find = (Individual)ind;
        this.rule = (SyntaxTreeClassificationRule)find.getPhenotype();
        int tp = 0;
        int fp = 0;
        int tn = 0;
        int fn = 0;
        IMetadata metadata = this.getDataset().getMetadata();
        IDataset.IInstance[] instances = this.getDataset().getInstances();
        int numInstances = instances.length;
        int j = 0;
        while (j < numInstances) {
            IDataset.IInstance instance = instances[j];
            double value = instance.getValue(metadata.getClassIndex());
            if (this.rule.covers(instance)) {
                if (value == (double)this.classifiedClass) {
                    ++tp;
                } else {
                    ++fp;
                }
            } else if (value != (double)this.classifiedClass) {
                ++tn;
            } else {
                ++fn;
            }
            ++j;
        }
        double fitness = (float)tp / ((float)tp + this.w1 * (float)fn) * ((float)tn / ((float)tn + this.w2 * (float)fp));
        ind.setFitness(new SimpleValueFitness(fitness));
    }

    @Override
    public Comparator<IFitness> getComparator() {
        if (this.comparator == null) {
            this.comparator = new ValueFitnessComparator(!this.maximize);
        }
        return this.comparator;
    }
}

