/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import moa.gui.experimentertab.statisticaltests.PValuePerTwoAlgorithm;
import moa.gui.experimentertab.statisticaltests.RankPerAlgorithm;
import nz.ac.waikato.cms.gui.core.BaseFileChooser;
import org.jfree.ui.FontChooserPanel;
import org.jfree.ui.StrokeChooserPanel;
import org.jfree.ui.StrokeSample;
import weka.gui.ExtensionFileFilter;

public class RankingGraph
extends JFrame {
    JPanel zoomPanel;
    JPanel graphPanel;
    JPanel graphPanelDisplay = new JPanel();
    JPanel controlPanelDisplay = new JPanel();
    JPanel controlPanel;
    JPanel imgOptionsPanel;
    JPanel exportPanel;
    JButton btnSave;
    JButton btnLineStroke;
    JButton btnFont;
    JButton btnLineDifStronke;
    JButton btnDir;
    JSlider xSlider;
    JSlider ySlider;
    int height;
    int width;
    int x0;
    int y0;
    int xScale;
    int yScale;
    double pvalue;
    Font textFont = new Font("Arial", 0, 14);
    ArrayList<RankPerAlgorithm> algRank;
    ArrayList<PValuePerTwoAlgorithm> PValues;
    static final BasicStroke currentStroke = new BasicStroke(1.0f);
    static final float[] dash1 = new float[]{1.5f};
    static final BasicStroke dashed = new BasicStroke(1.5f, 0, 0, 10.0f, dash1, 0.0f);
    private StrokeSample[] availableStrokeSamples;
    private StrokeSample stroke = new StrokeSample((Stroke)currentStroke);
    private StrokeSample difStroke = new StrokeSample((Stroke)new BasicStroke(3.0f));
    public BufferedImage image;
    public Graphics2D gb;
    public String imgPath;

    public RankingGraph(ArrayList<RankPerAlgorithm> algRank, ArrayList<PValuePerTwoAlgorithm> PValues, String imgPath, double pvalue) {
        super("Ranking Viewer");
        this.algRank = algRank;
        this.PValues = PValues;
        this.imgPath = imgPath;
        this.pvalue = pvalue;
        this.setSize(800, 640);
        this.initComponents();
        this.setDefaultCloseOperation(1);
        this.setVisible(true);
    }

    private void initComponents() {
        Container container = this.getContentPane();
        this.width = this.getSize().width - 10;
        this.height = 70 * this.getSize().height / 100;
        this.graphPanel = new Graph();
        this.zoomPanel = new SliderPanel();
        this.controlPanel = new JPanel();
        this.imgOptionsPanel = new JPanel();
        this.exportPanel = new JPanel();
        this.btnSave = new JButton("Save");
        this.btnLineStroke = new JButton("Line 1 Stroke");
        this.btnFont = new JButton("Text Font");
        this.btnLineDifStronke = new JButton("Line 2 Stroke");
        this.btnDir = new JButton("Save as");
        this.graphPanelDisplay.setLayout(new BorderLayout());
        this.graphPanelDisplay.add((Component)this.graphPanel, "Center");
        TitledBorder titleborder = BorderFactory.createTitledBorder(" Zoom");
        this.zoomPanel.setBorder(titleborder);
        titleborder = BorderFactory.createTitledBorder("Properties");
        this.imgOptionsPanel.setBorder(titleborder);
        titleborder = BorderFactory.createTitledBorder("Export");
        this.exportPanel.setBorder(titleborder);
        this.graphPanelDisplay.setPreferredSize(new Dimension(this.width, this.height));
        this.controlPanel.setPreferredSize(new Dimension(60 * this.width / 100, 20 * this.getSize().height / 100));
        this.zoomPanel.setPreferredSize(new Dimension(30 * this.width / 100, 20 * this.getSize().height / 100));
        EventControl evt = new EventControl();
        this.btnFont.addActionListener(evt);
        this.btnLineDifStronke.addActionListener(evt);
        this.btnLineStroke.addActionListener(evt);
        this.btnSave.addActionListener(evt);
        this.btnDir.addActionListener(evt);
        this.imgOptionsPanel.add(this.btnFont);
        this.imgOptionsPanel.add(this.btnLineStroke);
        this.imgOptionsPanel.add(this.btnLineDifStronke);
        this.exportPanel.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        JPanel panelName = new JPanel();
        panelName.add(this.btnDir);
        this.exportPanel.add((Component)panelName, "Center");
        this.exportPanel.add((Component)panel, "South");
        this.controlPanel.setLayout(new BorderLayout());
        this.controlPanel.add((Component)this.imgOptionsPanel, "Center");
        this.controlPanel.add((Component)this.exportPanel, "East");
        this.controlPanelDisplay.setLayout(new BorderLayout(1, 1));
        this.controlPanelDisplay.add((Component)this.controlPanel, "Center");
        this.controlPanelDisplay.add((Component)this.zoomPanel, "East");
        container.setLayout(new BorderLayout(1, 1));
        container.add("Center", this.graphPanelDisplay);
        container.add("South", this.controlPanelDisplay);
        this.xScale = 20;
        this.yScale = 20;
        this.x0 = this.width / 2;
        this.y0 = this.height / 5;
        this.availableStrokeSamples = new StrokeSample[4];
        this.availableStrokeSamples[0] = new StrokeSample((Stroke)new BasicStroke(1.5f, 0, 0, 10.0f, dash1, 0.0f));
        this.availableStrokeSamples[1] = new StrokeSample((Stroke)new BasicStroke(1.0f));
        this.availableStrokeSamples[2] = new StrokeSample((Stroke)new BasicStroke(2.0f));
        this.availableStrokeSamples[3] = new StrokeSample((Stroke)new BasicStroke(3.0f));
        this.addWindowStateListener(arg0 -> {
            this.width = this.getSize().width - 10;
            this.height = 70 * this.getSize().height / 100;
            this.x0 = this.width / 2;
            this.y0 = this.height / 5;
            this.xScale = 20;
            this.yScale = 20;
            this.xSlider.setValue(50);
            this.ySlider.setValue(20);
        });
    }

    private void strokeSelection(StrokeSample str) {
        StrokeChooserPanel panel = new StrokeChooserPanel(str, this.availableStrokeSamples);
        int result = JOptionPane.showConfirmDialog(this, panel, "Stroke Selection", 2, -1);
        if (result == 0) {
            str.setStroke(panel.getSelectedStroke());
        }
    }

    public void fontSelection() {
        FontChooserPanel panel = new FontChooserPanel(this.textFont);
        int result = JOptionPane.showConfirmDialog(this, panel, "Font Selection", 2, -1);
        if (result == 0) {
            this.textFont = panel.getSelectedFont();
        }
    }

    public class SliderPanel
    extends JPanel {
        public SliderPanel() {
            this.setLayout(new GridLayout(1, 2));
            RankingGraph.this.xSlider = new JSlider(1, -400, 400, 50);
            RankingGraph.this.xSlider.addChangeListener(e -> {
                RankingGraph.this.xScale = RankingGraph.this.xSlider.getValue();
                RankingGraph.this.graphPanel.repaint();
            });
            this.add(RankingGraph.this.xSlider);
            RankingGraph.this.ySlider = new JSlider(1, 1, 400, 20);
            RankingGraph.this.ySlider.addChangeListener(e -> {
                RankingGraph.this.yScale = RankingGraph.this.ySlider.getValue();
                RankingGraph.this.graphPanel.repaint();
            });
            this.add(RankingGraph.this.ySlider);
            RankingGraph.this.xSlider.setMinorTickSpacing(20);
            RankingGraph.this.xSlider.setPaintTicks(true);
            RankingGraph.this.xSlider.setPaintLabels(true);
            RankingGraph.this.ySlider.setMinorTickSpacing(20);
            RankingGraph.this.ySlider.setPaintTicks(true);
            RankingGraph.this.ySlider.setPaintLabels(true);
        }
    }

    class Graph
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        int offsetX;
        int offsetY;
        boolean dragging;

        Graph() {
            this.setBackground(Color.white);
            this.offsetX = RankingGraph.this.x0;
            this.offsetY = RankingGraph.this.y0;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (this.dragging) {
                return;
            }
            int x = evt.getX();
            int y = evt.getY();
            this.offsetX = x - RankingGraph.this.x0;
            this.offsetY = y - RankingGraph.this.y0;
            this.dragging = true;
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.dragging = false;
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (!this.dragging) {
                return;
            }
            int x = evt.getX();
            int y = evt.getY();
            RankingGraph.this.x0 = x - this.offsetX;
            RankingGraph.this.y0 = y - this.offsetY;
            this.repaint();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            double value = (double)0.05f * e.getPreciseWheelRotation();
            int xleft = RankingGraph.this.x0 - RankingGraph.this.width / 3;
            int xrigth = RankingGraph.this.x0 + RankingGraph.this.width / 3;
            if (value > 0.0 && xrigth + RankingGraph.this.xScale - (xleft - RankingGraph.this.xScale) <= 50) {
                return;
            }
            RankingGraph.this.xScale = (int)((double)RankingGraph.this.xScale - value * 100.0);
            this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.Graficar(g, RankingGraph.this.x0, RankingGraph.this.y0);
        }

        void Graficar(Graphics ap, int xg, int yg) {
            int k;
            int i;
            Graphics2D g = (Graphics2D)ap;
            RankingGraph.this.image = new BufferedImage(RankingGraph.this.width, RankingGraph.this.height, 4);
            RankingGraph.this.gb = RankingGraph.this.image.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RankingGraph.this.gb.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setFont(RankingGraph.this.textFont);
            RankingGraph.this.gb.setFont(RankingGraph.this.textFont);
            g.setPaint(Color.BLACK);
            RankingGraph.this.gb.setBackground(Color.WHITE);
            RankingGraph.this.gb.clearRect(0, 0, RankingGraph.this.image.getWidth(), RankingGraph.this.image.getHeight());
            RankingGraph.this.gb.setColor(Color.BLACK);
            int xleft = xg - RankingGraph.this.width / 3;
            int xrigth = xg + RankingGraph.this.width / 3;
            g.setStroke(RankingGraph.this.stroke.getStroke());
            RankingGraph.this.gb.setStroke(RankingGraph.this.stroke.getStroke());
            int xin = xleft - RankingGraph.this.xScale;
            int xfin = xrigth + RankingGraph.this.xScale;
            int rank1 = (int)Math.floor(RankingGraph.this.algRank.get((int)0).rank);
            int ticks = (int)Math.ceil(RankingGraph.this.algRank.get((int)(RankingGraph.this.algRank.size() - 1)).rank);
            int xdiv = (xfin - xin) / ticks;
            int xinr = rank1 * xdiv + xin;
            g.draw(new Line2D.Double(xinr, yg, xrigth + RankingGraph.this.xScale, yg));
            RankingGraph.this.gb.draw(new Line2D.Double(xinr, yg, xrigth + RankingGraph.this.xScale, yg));
            int j = rank1;
            g.setStroke(currentStroke);
            RankingGraph.this.gb.setStroke(currentStroke);
            for (int i2 = xinr; i2 <= xfin; i2 += xdiv) {
                g.draw(new Line2D.Double(i2, yg - 4, i2, yg));
                g.drawString("" + j, i2, yg - 6);
                RankingGraph.this.gb.draw(new Line2D.Double(i2, yg - 4, i2, yg));
                RankingGraph.this.gb.drawString("" + j, i2, yg - 6);
                ++j;
            }
            int ydiv = RankingGraph.this.height / 2 / 4 - RankingGraph.this.height / 10;
            int ya = ydiv + RankingGraph.this.yScale;
            FontMetrics fm = g.getFontMetrics();
            g.setStroke(RankingGraph.this.stroke.getStroke());
            RankingGraph.this.gb.setStroke(RankingGraph.this.stroke.getStroke());
            boolean[][] visited = new boolean[RankingGraph.this.algRank.size()][RankingGraph.this.algRank.size()];
            for (i = 0; i < RankingGraph.this.algRank.size(); ++i) {
                for (k = 0; k < RankingGraph.this.algRank.size(); ++k) {
                    visited[i][k] = false;
                }
            }
            for (i = 0; i < RankingGraph.this.algRank.size(); ++i) {
                int index;
                boolean v;
                g.draw(new Line2D.Double((double)xdiv * RankingGraph.this.algRank.get((int)i).rank + (double)xin, yg + ya, (double)xdiv * RankingGraph.this.algRank.get((int)i).rank + (double)xin, yg));
                RankingGraph.this.gb.draw(new Line2D.Double((double)xdiv * RankingGraph.this.algRank.get((int)i).rank + (double)xin, yg + ya, (double)xdiv * RankingGraph.this.algRank.get((int)i).rank + (double)xin, yg));
                for (k = i + 1; k <= RankingGraph.this.algRank.size() - 1 && (v = RankingGraph.this.PValues.get(index = PValuePerTwoAlgorithm.getIndex(RankingGraph.this.PValues, RankingGraph.this.algRank.get((int)i).algName, RankingGraph.this.algRank.get((int)k).algName)).isSignicativeBetterThan(RankingGraph.this.pvalue)); ++k) {
                    visited[i][k] = true;
                }
                g.setStroke(RankingGraph.this.difStroke.getStroke());
                RankingGraph.this.gb.setStroke(RankingGraph.this.difStroke.getStroke());
                if (i == 0 && k - 1 != 0) {
                    g.draw(new Line2D.Double((double)xdiv * RankingGraph.this.algRank.get((int)i).rank + (double)xin, (yg + ya + yg) / 2, (double)xdiv * RankingGraph.this.algRank.get((int)(k - 1)).rank + (double)xin, (yg + ya + yg) / 2));
                    RankingGraph.this.gb.draw(new Line2D.Double((double)xdiv * RankingGraph.this.algRank.get((int)i).rank + (double)xin, (yg + ya + yg) / 2, (double)xdiv * RankingGraph.this.algRank.get((int)(k - 1)).rank + (double)xin, (yg + ya + yg) / 2));
                } else if (i != 0 && !visited[i - 1][k - 1] && i != k - 1) {
                    g.draw(new Line2D.Double((double)xdiv * RankingGraph.this.algRank.get((int)i).rank + (double)xin, (yg + ya + yg) / 2, (double)xdiv * RankingGraph.this.algRank.get((int)(k - 1)).rank + (double)xin, (yg + ya + yg) / 2));
                    RankingGraph.this.gb.draw(new Line2D.Double((double)xdiv * RankingGraph.this.algRank.get((int)i).rank + (double)xin, (yg + ya + yg) / 2, (double)xdiv * RankingGraph.this.algRank.get((int)(k - 1)).rank + (double)xin, (yg + ya + yg) / 2));
                }
                g.setStroke(RankingGraph.this.stroke.getStroke());
                RankingGraph.this.gb.setStroke(RankingGraph.this.stroke.getStroke());
                if (i < RankingGraph.this.algRank.size() / 2) {
                    int lenght = fm.stringWidth(RankingGraph.this.algRank.get((int)i).algName);
                    g.draw(new Line2D.Double((double)xdiv * RankingGraph.this.algRank.get((int)i).rank + (double)xin, yg + ya, xinr - 3, yg + ya));
                    g.drawString(RankingGraph.this.algRank.get((int)i).algName, xinr - 3 - lenght - 10, yg + ya);
                    RankingGraph.this.gb.draw(new Line2D.Double((double)xdiv * RankingGraph.this.algRank.get((int)i).rank + (double)xin, yg + ya, xinr - 3, yg + ya));
                    RankingGraph.this.gb.drawString(RankingGraph.this.algRank.get((int)i).algName, xinr - 3 - lenght - 10, yg + ya);
                } else {
                    g.draw(new Line2D.Double((double)xdiv * RankingGraph.this.algRank.get((int)i).rank + (double)xin, yg + ya, xfin + 3, yg + ya));
                    g.drawString(RankingGraph.this.algRank.get((int)i).algName, xfin + 3 + 10, yg + ya);
                    RankingGraph.this.gb.draw(new Line2D.Double((double)xdiv * RankingGraph.this.algRank.get((int)i).rank + (double)xin, yg + ya, xfin + 3, yg + ya));
                    RankingGraph.this.gb.drawString(RankingGraph.this.algRank.get((int)i).algName, xfin + 3 + 10, yg + ya);
                }
                ya += 20;
            }
        }
    }

    private class EventControl
    implements ActionListener {
        private EventControl() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source != RankingGraph.this.btnSave) {
                if (source == RankingGraph.this.btnFont) {
                    RankingGraph.this.fontSelection();
                } else if (source == RankingGraph.this.btnLineStroke) {
                    RankingGraph.this.strokeSelection(RankingGraph.this.stroke);
                } else if (source == RankingGraph.this.btnLineDifStronke) {
                    RankingGraph.this.strokeSelection(RankingGraph.this.difStroke);
                } else if (source == RankingGraph.this.btnDir) {
                    BaseFileChooser fileChooser = new BaseFileChooser();
                    ExtensionFileFilter filterPNG = new ExtensionFileFilter(".png", "PNG Image Files");
                    fileChooser.addChoosableFileFilter((FileFilter)filterPNG);
                    ExtensionFileFilter filterJPG = new ExtensionFileFilter(".jpg", "JPG Image Files");
                    fileChooser.addChoosableFileFilter((FileFilter)filterJPG);
                    ExtensionFileFilter filterEPS = new ExtensionFileFilter(".eps", "EPS Image Files");
                    fileChooser.addChoosableFileFilter((FileFilter)filterEPS);
                    fileChooser.setAcceptAllFileFilterUsed(false);
                    fileChooser.setCurrentDirectory(new File(RankingGraph.this.imgPath));
                    int option = fileChooser.showSaveDialog(null);
                    if (option == 0) {
                        String fileDesc = fileChooser.getFileFilter().getDescription();
                        if (fileDesc.startsWith("PNG")) {
                            if (fileChooser.getSelectedFile().getName().toUpperCase().endsWith("PNG")) {
                                try {
                                    ImageIO.write((RenderedImage)RankingGraph.this.image, "png", fileChooser.getSelectedFile());
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                try {
                                    ImageIO.write((RenderedImage)RankingGraph.this.image, "png", new File(fileChooser.getSelectedFile().getAbsolutePath() + ".png"));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        } else if (fileDesc.startsWith("JPG")) {
                            if (fileChooser.getSelectedFile().getName().toUpperCase().endsWith("JPG")) {
                                try {
                                    ImageIO.write((RenderedImage)RankingGraph.this.image, "jpg", fileChooser.getSelectedFile());
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                try {
                                    ImageIO.write((RenderedImage)RankingGraph.this.image, "jpg", new File(fileChooser.getSelectedFile().getAbsolutePath() + ".jpg"));
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }
            }
            RankingGraph.this.graphPanel.repaint();
        }
    }
}

