/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import org.jpmml.rexp.RBooleanVector;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExpUtil;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RIntegerVector;
import org.jpmml.rexp.RPair;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RVector;

public abstract class RExp {
    private RPair attributes = null;

    public RExp(RPair attributes) {
        this.setAttributes(attributes);
    }

    public RStringVector names() {
        return this.getStringAttribute("names");
    }

    public RIntegerVector dim() {
        return this.getIntegerAttribute("dim");
    }

    public RStringVector dimnames(int index) {
        RGenericVector dimnames = this.getGenericAttribute("dimnames");
        return dimnames.getStringValue(index);
    }

    public RExp getAttribute(String name) {
        return this.getAttribute(name, true);
    }

    public RExp getAttribute(String name, boolean required) {
        return this.findAttribute(name, required);
    }

    public RBooleanVector getBooleanAttribute(String name) {
        return this.getBooleanAttribute(name, true);
    }

    public RBooleanVector getBooleanAttribute(String name, boolean required) {
        return this.getVectorAttribute(RBooleanVector.class, name, required);
    }

    public RDoubleVector getDoubleAttribute(String name) {
        return this.getDoubleAttribute(name, true);
    }

    public RDoubleVector getDoubleAttribute(String name, boolean required) {
        return this.getVectorAttribute(RDoubleVector.class, name, required);
    }

    public RGenericVector getGenericAttribute(String name) {
        return this.getGenericAttribute(name, true);
    }

    public RGenericVector getGenericAttribute(String name, boolean required) {
        return this.getVectorAttribute(RGenericVector.class, name, required);
    }

    public RIntegerVector getIntegerAttribute(String name) {
        return this.getIntegerAttribute(name, true);
    }

    public RIntegerVector getIntegerAttribute(String name, boolean required) {
        return this.getVectorAttribute(RIntegerVector.class, name, required);
    }

    public RStringVector getStringAttribute(String name) {
        return this.getStringAttribute(name, true);
    }

    public RStringVector getStringAttribute(String name, boolean required) {
        return this.getVectorAttribute(RStringVector.class, name, required);
    }

    private <V extends RVector<E>, E> V getVectorAttribute(Class<V> clazz, String name, boolean required) {
        RExp rexp = this.getAttribute(name, required);
        try {
            return (V)((RVector)clazz.cast(rexp));
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Invalid '" + name + "' attribute. Expected " + RExpUtil.getVectorType(clazz) + ", got " + RExpUtil.getVectorType(rexp.getClass()));
        }
    }

    public boolean hasAttribute(String name) {
        for (RPair attribute = this.getAttributes(); attribute != null; attribute = attribute.getNext()) {
            if (!attribute.tagEquals(name)) continue;
            return true;
        }
        return false;
    }

    private RExp findAttribute(String name, boolean required) {
        for (RPair attribute = this.getAttributes(); attribute != null; attribute = attribute.getNext()) {
            if (!attribute.tagEquals(name)) continue;
            return attribute.getValue();
        }
        if (required) {
            throw new IllegalArgumentException("Missing '" + name + "' attribute");
        }
        return null;
    }

    public RPair getAttributes() {
        return this.attributes;
    }

    private void setAttributes(RPair attributes) {
        this.attributes = attributes;
    }
}

