/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model.variables;

import choco.kernel.model.IConstraintList;
import choco.kernel.model.Model;
import choco.kernel.model.ModelException;
import choco.kernel.model.ModelObject;
import choco.kernel.model.VariableArray;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import java.util.Iterator;

public abstract class AbstractVariable
extends ModelObject
implements Variable,
Comparable {
    private static final String NO_NAME = "";
    protected final VariableType type;
    protected String name = "";
    private final IConstraintList constraints;
    private int hook = Integer.MIN_VALUE;

    public AbstractVariable(VariableType type, boolean enableOption, IConstraintList constraints) {
        super(enableOption);
        this.type = type;
        this.constraints = constraints;
    }

    public AbstractVariable(VariableType type, boolean enableOptions) {
        super(enableOptions);
        this.type = type;
        this.constraints = new VariableArray.VConstraintsDataStructure();
    }

    public AbstractVariable(VariableType type, Variable[] variables, boolean enableOptions) {
        super(variables, enableOptions);
        this.type = type;
        this.constraints = new VariableArray.VConstraintsDataStructure();
    }

    protected static void throwConstantException() {
        throw new ModelException("Constant are immutable.");
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public final VariableType getVariableType() {
        return this.type;
    }

    @Override
    public String pretty() {
        return this.type.name() + super.pretty();
    }

    @Override
    public String toString() {
        return this.pretty();
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        return 1;
    }

    @Override
    public final void _addConstraint(Constraint c) {
        this.constraints._addConstraint(c);
    }

    @Override
    public final void _removeConstraint(Constraint c) {
        this.constraints._removeConstraint(c);
    }

    @Override
    public boolean _contains(Constraint c) {
        return this.constraints._contains(c);
    }

    @Override
    @Deprecated
    public Iterator<Constraint> getConstraintIterator() {
        throw new UnsupportedOperationException("deprecated");
    }

    @Override
    public final Iterator<Constraint> getConstraintIterator(Model m) {
        return this.constraints.getConstraintIterator(m);
    }

    @Override
    public Constraint[] getConstraints() {
        return this.constraints.getConstraints();
    }

    @Override
    public final Constraint getConstraint(int idx) {
        return this.constraints.getConstraint(idx);
    }

    @Override
    @Deprecated
    public int getNbConstraint() {
        throw new UnsupportedOperationException("deprecated");
    }

    @Override
    public int getNbConstraint(Model m) {
        return this.constraints.getNbConstraint(m);
    }

    @Override
    public void removeConstraints() {
        this.constraints.removeConstraints();
    }

    @Override
    public final int getHook() {
        return this.hook;
    }

    @Override
    public final void resetHook() {
        this.hook = Integer.MIN_VALUE;
    }

    @Override
    public final void setHook(int hook) {
        if (this.hook != Integer.MIN_VALUE) {
            throw new ModelException("The hook of the variable " + this.pretty() + " is already set to " + this.hook);
        }
        this.hook = hook;
    }
}

