/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.algorithm;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.parametric.ParametricMutator;
import net.sf.jclec.IConfigure;
import net.sf.jclec.IEvaluator;
import net.sf.jclec.IIndividual;
import net.sf.jclec.IMutator;
import net.sf.jclec.IPopulation;
import net.sf.jclec.IProvider;
import net.sf.jclec.ISpecies;
import net.sf.jclec.algorithm.AbstractAlgorithm;
import net.sf.jclec.fitness.SimpleValueFitness;
import net.sf.jclec.util.random.IRandGen;
import net.sf.jclec.util.random.IRandGenFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

public class NeuralNetAlgorithm<I extends IIndividual>
extends AbstractAlgorithm<I>
implements IPopulation<I>,
IConfigure {
    private static final long serialVersionUID = 7315921806325890102L;
    protected IRandGenFactory randGenFactory;
    protected ISpecies<I> species;
    protected IEvaluator<I> evaluator;
    protected IProvider<I> provider;
    protected int populationSize;
    protected int maxOfGenerations;
    protected IMutator<I> mutator1;
    protected IMutator<I> mutator2;
    protected double cratio;
    protected int percentageSecondMutator;
    protected int nofselSecondMutator;
    protected int mogmean;
    protected int mogbest;
    protected double fitDif;
    protected int generation;
    protected List<I> bset;
    protected List<I> pset1;
    protected List<I> pset2;
    protected List<I> cset;
    protected List<I> rset;
    protected double currentBest = 0.0;
    protected double currentMean = 0.0;
    protected double previousBest = 0.0;
    protected double previousMean = 0.0;
    protected int nogbest = 0;
    protected int nogmean = 0;
    protected I bestIndividual;
    protected Comparator<I> individualsComparator = new Comparator<I>(){

        @Override
        public int compare(I arg0, I arg1) {
            return NeuralNetAlgorithm.this.evaluator.getComparator().compare(arg0.getFitness(), arg1.getFitness());
        }
    };

    @Override
    public final ISpecies<I> getSpecies() {
        return this.species;
    }

    @Override
    public final IEvaluator<I> getEvaluator() {
        return this.evaluator;
    }

    @Override
    public final int getGeneration() {
        return this.generation;
    }

    @Override
    public List<I> getInhabitants() {
        return this.bset;
    }

    public double getCurrentBest() {
        return this.currentBest;
    }

    public double getCurrentMean() {
        return this.currentMean;
    }

    public int getNogbest() {
        return this.nogbest;
    }

    public int getNogmean() {
        return this.nogmean;
    }

    public double getPreviousBest() {
        return this.previousBest;
    }

    public double getPreviousMean() {
        return this.previousMean;
    }

    public I getBestIndividual() {
        return this.bestIndividual;
    }

    public final void setSpecies(ISpecies<I> species) {
        this.species = species;
    }

    public final void setEvaluator(IEvaluator<I> evaluator) {
        this.evaluator = evaluator;
    }

    public final void setGeneration(int generation) {
        this.generation = generation;
    }

    public final void setInhabitants(List<I> inhabitants) {
        this.bset = inhabitants;
    }

    public IRandGenFactory getRandGenFactory() {
        return this.randGenFactory;
    }

    public void setRandGenFactory(IRandGenFactory randGenFactory) {
        this.randGenFactory = randGenFactory;
    }

    public final IProvider<I> getProvider() {
        return this.provider;
    }

    public final void setProvider(IProvider<I> provider) {
        this.provider = provider;
        this.provider.contextualize(this);
    }

    public final int getPopulationSize() {
        return this.populationSize;
    }

    public final void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public final int getMaxOfGenerations() {
        return this.maxOfGenerations;
    }

    public final void setMaxOfGenerations(int maxOfGenerations) {
        this.maxOfGenerations = maxOfGenerations;
    }

    public IMutator<I> getMutator1() {
        return this.mutator1;
    }

    public void setMutator1(IMutator<I> mutator1) {
        this.mutator1 = mutator1;
        this.mutator1.contextualize(this);
    }

    public IMutator<I> getMutator2() {
        return this.mutator2;
    }

    public void setMutator2(IMutator<I> mutator2) {
        this.mutator2 = mutator2;
        this.mutator2.contextualize(this);
    }

    public double getCratio() {
        return this.cratio;
    }

    public void setCratio(double cratio) {
        this.cratio = cratio;
    }

    public int getPercentageSecondMutator() {
        return this.percentageSecondMutator;
    }

    public void setPercentageSecondMutator(int percentageSecondMutator) {
        this.percentageSecondMutator = percentageSecondMutator;
        this.nofselSecondMutator = (int)((double)percentageSecondMutator / 100.0 * (double)this.populationSize);
    }

    public double getFitDif() {
        return this.fitDif;
    }

    public void setFitDif(double fitDif) {
        this.fitDif = fitDif;
    }

    public int getMogbest() {
        return this.mogbest;
    }

    public void setMogbest(int mogbest) {
        this.mogbest = mogbest;
    }

    public int getMogmean() {
        return this.mogmean;
    }

    public void setMogmean(int mogmean) {
        this.mogmean = mogmean;
    }

    public boolean equals(Object other) {
        if (other instanceof NeuralNetAlgorithm) {
            NeuralNetAlgorithm cother = (NeuralNetAlgorithm)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.randGenFactory, cother.randGenFactory);
            eb.append(this.species, cother.species);
            eb.append(this.evaluator, cother.evaluator);
            eb.append(this.provider, cother.provider);
            eb.append(this.populationSize, cother.populationSize);
            eb.append(this.maxOfGenerations, cother.maxOfGenerations);
            eb.append(this.mutator1, cother.mutator1);
            eb.append(this.mutator2, cother.mutator2);
            eb.append(this.cratio, cother.cratio);
            eb.append(this.percentageSecondMutator, cother.percentageSecondMutator);
            eb.append(this.nofselSecondMutator, cother.nofselSecondMutator);
            eb.append(this.mogmean, cother.mogmean);
            eb.append(this.mogbest, cother.mogbest);
            eb.append(this.fitDif, cother.fitDif);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    public void doInit() {
        this.currentBest = 0.0;
        this.previousBest = 0.0;
        this.currentMean = 0.0;
        this.previousMean = 0.0;
        this.finished = false;
        this.generation = 0;
        this.nogbest = 0;
        this.nogmean = 0;
        this.bset = this.provider.provide((int)this.cratio * this.populationSize);
        this.evaluator.evaluate(this.bset);
        this.doSort();
        this.bestIndividual = ((IIndividual)this.bset.get(0)).copy();
        if (this.mutator1 instanceof ParametricMutator) {
            ((ParametricMutator)this.mutator1).alphaInit();
        }
        if (this.mutator2 instanceof ParametricMutator) {
            ((ParametricMutator)this.mutator2).alphaInit();
        }
    }

    @Override
    public void doIterate() {
        ++this.generation;
        this.doSelection();
        this.doGeneration();
        this.doReplacement();
        this.doUpdate();
        this.doControl();
    }

    protected void doControl() {
        if (this.generation >= this.maxOfGenerations) {
            this.finished = true;
            return;
        }
        if (this.nogbest >= this.mogbest && this.nogmean >= this.mogmean) {
            this.finished = true;
            return;
        }
    }

    protected void doSelection() {
        this.pset1 = this.bset.subList(this.nofselSecondMutator, this.populationSize);
        this.pset2 = this.bset.subList(0, this.nofselSecondMutator);
    }

    protected void doGeneration() {
        this.cset = this.mutator1.mutate(this.pset1);
        this.evaluator.evaluate(this.cset);
        IIndividual firstNnindPset1 = (IIndividual)this.pset1.get(0);
        this.cset.remove(firstNnindPset1);
        this.pset2.add(firstNnindPset1);
        this.cset.addAll(this.mutator2.mutate(this.pset2));
        this.evaluator.evaluate(this.cset);
    }

    protected void doReplacement() {
    }

    protected void doUpdate() {
        this.cset.add(this.bestIndividual);
        this.bset = this.cset;
        this.doSort();
        this.pset1 = null;
        this.pset2 = null;
        this.rset = null;
        this.cset = null;
        this.bestIndividual = ((IIndividual)this.bset.get(0)).copy();
        this.previousBest = this.currentBest;
        this.currentBest = ((SimpleValueFitness)this.bestIndividual.getFitness()).getValue();
        this.previousMean = this.currentMean;
        this.currentMean = 0.0;
        for (int i = 0; i < this.nofselSecondMutator; ++i) {
            this.currentMean += ((SimpleValueFitness)((IIndividual)this.bset.get(i)).getFitness()).getValue();
        }
        this.currentMean /= (double)this.nofselSecondMutator;
        this.nogbest = this.previousBest + this.fitDif < this.currentBest ? 0 : ++this.nogbest;
        this.nogmean = this.previousMean + this.fitDif < this.currentMean ? 0 : ++this.nogmean;
    }

    protected void doSort() {
        IIndividual[] tmp = this.bset.toArray(new IIndividual[this.bset.size()]);
        Arrays.sort(tmp, this.individualsComparator);
        this.bset.clear();
        int i = tmp.length - 1;
        int j = this.populationSize;
        while (j > this.nofselSecondMutator) {
            this.bset.add(tmp[i]);
            --j;
            --i;
        }
        i = tmp.length - 1;
        j = this.populationSize;
        while (j > this.populationSize - this.nofselSecondMutator) {
            this.bset.add(tmp[i].copy());
            --j;
            --i;
        }
    }

    @Override
    public IRandGen createRandGen() {
        return this.randGenFactory.createRandGen();
    }

    @Override
    public void configure(Configuration configuration) {
        try {
            String randGenFactoryClassname = configuration.getString("rand-gen-factory[@type]");
            Class<?> randGenFactoryClass = Class.forName(randGenFactoryClassname);
            IRandGenFactory randGenFactory = (IRandGenFactory)randGenFactoryClass.newInstance();
            if (randGenFactory instanceof IConfigure) {
                ((IConfigure)((Object)randGenFactory)).configure(configuration.subset("rand-gen-factory"));
            }
            this.setRandGenFactory(randGenFactory);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal random generators factory classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of random generators factory", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of random generators factory", e);
        }
        try {
            String speciesClassname = configuration.getString("species[@type]");
            Class<?> speciesClass = Class.forName(speciesClassname);
            ISpecies species = (ISpecies)speciesClass.newInstance();
            if (species instanceof IConfigure) {
                Configuration speciesConfiguration = configuration.subset("species");
                ((IConfigure)((Object)species)).configure(speciesConfiguration);
            }
            this.setSpecies(species);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal species classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of species", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of species", e);
        }
        try {
            String evaluatorClassname = configuration.getString("evaluator[@type]");
            Class<?> evaluatorClass = Class.forName(evaluatorClassname);
            IEvaluator evaluator = (IEvaluator)evaluatorClass.newInstance();
            if (evaluator instanceof IConfigure) {
                Configuration evaluatorConfiguration = configuration.subset("evaluator");
                ((IConfigure)((Object)evaluator)).configure(evaluatorConfiguration);
            }
            this.setEvaluator(evaluator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal evaluator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of evaluator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of evaluator", e);
        }
        int populationSize = configuration.getInt("population-size");
        this.setPopulationSize(populationSize);
        int maxOfGenerations = configuration.getInt("max-of-generations");
        this.setMaxOfGenerations(maxOfGenerations);
        try {
            String providerClassname = configuration.getString("provider[@type]");
            Class<?> providerClass = Class.forName(providerClassname);
            IProvider provider = (IProvider)providerClass.newInstance();
            if (provider instanceof IConfigure) {
                Configuration providerConfiguration = configuration.subset("provider");
                ((IConfigure)((Object)provider)).configure(providerConfiguration);
            }
            this.setProvider(provider);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal provider classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of provider", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of provider", e);
        }
        try {
            String mutator1Classname = configuration.getString("mutator1[@type]");
            Class<?> mutator1Class = Class.forName(mutator1Classname);
            IMutator mutator1 = (IMutator)mutator1Class.newInstance();
            if (mutator1 instanceof IConfigure) {
                Configuration mutator1Configuration = configuration.subset("mutator1");
                ((IConfigure)((Object)mutator1)).configure(mutator1Configuration);
            }
            this.setMutator1(mutator1);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal mutator1 classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator1", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator1", e);
        }
        try {
            String mutator2Classname = configuration.getString("mutator2[@type]");
            Class<?> mutator2Class = Class.forName(mutator2Classname);
            IMutator mutator2 = (IMutator)mutator2Class.newInstance();
            if (mutator2 instanceof IConfigure) {
                Configuration mutator2Configuration = configuration.subset("mutator2");
                ((IConfigure)((Object)mutator2)).configure(mutator2Configuration);
            }
            this.setMutator2(mutator2);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal mutator2 classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator2", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator2", e);
        }
        double cratio = configuration.getDouble("creation-ratio");
        this.setCratio(cratio);
        int percenageMutator2 = configuration.getInt("percentage-second-mutator");
        this.setPercentageSecondMutator(percenageMutator2);
        int mogmean = configuration.getInt("max-generations-without-improving-mean");
        this.setMogmean(mogmean);
        int mogbest = configuration.getInt("max-generations-without-improving-best");
        this.setMogbest(mogbest);
        double fitDif = configuration.getDouble("fitness-difference");
        this.setFitDif(fitDif);
    }
}

