/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.CART.tree;

public class TreeNode {
    private TreeNode parent;
    private TreeNode leftSon;
    private TreeNode rightSon;
    private int[] patterns;
    private int variable = -1;
    private double value = -1.0;
    private int outputClass = -1;
    private double outputValue = -1.0;
    private double impurities;

    public TreeNode(TreeNode parent) {
        this.parent = parent;
    }

    public TreeNode(TreeNode parent, int[] patterns) {
        this.parent = parent;
        this.patterns = patterns;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public TreeNode getLeftSon() {
        return this.leftSon;
    }

    public void setLeftSon(TreeNode leftSon) {
        this.leftSon = leftSon;
    }

    public TreeNode getRightSon() {
        return this.rightSon;
    }

    public void setRightSon(TreeNode rightSon) {
        this.rightSon = rightSon;
    }

    public int[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(int[] patterns) {
        this.patterns = patterns;
    }

    public int getVariable() {
        return this.variable;
    }

    public void setVariable(int variable) {
        this.variable = variable;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public int getOutputClass() {
        return this.outputClass;
    }

    public void setOutputClass(int outputClass) {
        this.outputClass = outputClass;
    }

    public double getOutputValue() {
        return this.outputValue;
    }

    public void setOutputValue(double outputValue) {
        this.outputValue = outputValue;
    }

    public double getImpurities() {
        return this.impurities;
    }

    public void setImpurities(double impurities) {
        this.impurities = impurities;
    }

    public int depth() {
        int leftDepth = this.leftSon != null ? this.leftSon.depth() : 0;
        int rightDepth = this.rightSon != null ? this.rightSon.depth() : 0;
        return 1 + Math.max(leftDepth, rightDepth);
    }

    public boolean isTerminal() {
        return this.leftSon == null && this.rightSon == null;
    }

    public double evaluate(double[] pattern, boolean regression) {
        if (this.isTerminal()) {
            if (regression) {
                return this.outputValue;
            }
            return this.outputClass;
        }
        if (pattern[this.variable] <= this.value) {
            return this.leftSon.evaluate(pattern, regression);
        }
        return this.rightSon.evaluate(pattern, regression);
    }

    public String toString() {
        String result = new String();
        if (this.isTerminal()) {
            result = this.outputClass != -1 ? "Class: " + this.outputClass + "\n" : "Mean: " + this.outputValue + "\n";
        } else {
            result = "If " + this.variable + " <= " + this.value + ";\n ";
            if (this.leftSon != null) {
                result = result + "Then " + this.leftSon.toString();
            }
            if (this.rightSon != null) {
                result = result + "Else\n" + this.rightSon.toString();
            }
        }
        return result;
    }
}

