/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.Utils;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixLatex
extends ResultMatrix {
    public ResultMatrixLatex() {
        this(1, 1);
    }

    public ResultMatrixLatex(int n, int n2) {
        super(n, n2);
    }

    public ResultMatrixLatex(ResultMatrix resultMatrix) {
        super(resultMatrix);
    }

    public String getDisplayName() {
        return "LaTeX";
    }

    public void clear() {
        super.clear();
        this.setPrintColNames(false);
        this.setEnumerateColNames(true);
        this.TIE_STRING = " ";
        this.WIN_STRING = "$\\circ$";
        this.LOSS_STRING = "$\\bullet$";
    }

    public String toStringHeader() {
        return new ResultMatrixPlainText(this).toStringHeader();
    }

    public String toStringMatrix() {
        int n;
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        String[][] stringArray = this.toArray();
        stringBuffer.append("\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption}\n");
        if (!this.getShowStdDev()) {
            stringBuffer.append("\\footnotesize\n");
        } else {
            stringBuffer.append("\\scriptsize\n");
        }
        if (!this.getShowStdDev()) {
            stringBuffer.append("{\\centering \\begin{tabular}{lr");
        } else {
            stringBuffer.append("{\\centering \\begin{tabular}{lr@{\\hspace{0cm}}c@{\\hspace{0cm}}r");
        }
        for (n3 = 1; n3 < this.getColCount(); ++n3) {
            if (this.getColHidden(n3)) continue;
            if (!this.getShowStdDev()) {
                stringBuffer.append("r@{\\hspace{0.1cm}}c");
                continue;
            }
            stringBuffer.append("r@{\\hspace{0cm}}c@{\\hspace{0cm}}r@{\\hspace{0.1cm}}c");
        }
        stringBuffer.append("}\n\\\\\n\\hline\n");
        if (!this.getShowStdDev()) {
            stringBuffer.append("Dataset & " + stringArray[0][1]);
        } else {
            stringBuffer.append("Dataset & \\multicolumn{3}{c}{" + stringArray[0][1] + "}");
        }
        for (n3 = 2; n3 < stringArray[0].length; ++n3) {
            if (!this.isMean(n3)) continue;
            if (!this.getShowStdDev()) {
                stringBuffer.append("& " + stringArray[0][n3] + " & ");
                continue;
            }
            stringBuffer.append("& \\multicolumn{4}{c}{" + stringArray[0][n3] + "} ");
        }
        stringBuffer.append("\\\\\n\\hline\n");
        for (n2 = 1; n2 < stringArray.length; ++n2) {
            stringArray[n2][0] = stringArray[n2][0].replace('_', '-');
        }
        for (n = 1; n < stringArray[0].length; ++n) {
            int n4 = this.getColSize(stringArray, n);
            for (n2 = 1; n2 < stringArray.length; ++n2) {
                stringArray[n2][n] = this.padString(stringArray[n2][n], n4, true);
            }
        }
        for (n2 = 1; n2 < stringArray.length - 1; ++n2) {
            if (this.isAverage(n2)) {
                stringBuffer.append("\\hline\n");
            }
            for (n = 0; n < stringArray[0].length; ++n) {
                if (n == 0) {
                    stringBuffer.append(this.padString(stringArray[n2][n], this.getRowNameWidth()));
                    continue;
                }
                if (this.getShowStdDev()) {
                    if (this.isMean(n - 1)) {
                        if (!stringArray[n2][n].trim().equals("")) {
                            stringBuffer.append(" & $\\pm$ & ");
                        } else {
                            stringBuffer.append(" &       & ");
                        }
                    } else {
                        stringBuffer.append(" & ");
                    }
                } else {
                    stringBuffer.append(" & ");
                }
                stringBuffer.append(stringArray[n2][n]);
            }
            stringBuffer.append("\\\\\n");
        }
        stringBuffer.append("\\hline\n\\multicolumn{" + stringArray[0].length + "}{c}{$\\circ$, $\\bullet$" + " statistically significant improvement or degradation}" + "\\\\\n\\end{tabular} ");
        if (!this.getShowStdDev()) {
            stringBuffer.append("\\footnotesize ");
        } else {
            stringBuffer.append("\\scriptsize ");
        }
        stringBuffer.append("\\par}\n\\end{table}\n");
        return stringBuffer.toString();
    }

    public String toStringKey() {
        String string = "\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption (Key)}\n";
        string = string + "\\scriptsize\n";
        string = string + "{\\centering\n";
        string = string + "\\begin{tabular}{cl}\\\\\n";
        for (int i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            string = string + this.LEFT_PARENTHESES + (i + 1) + this.RIGHT_PARENTHESES + " & " + this.removeFilterName(this.m_ColNames[i]).replace('_', '-').replaceAll("\\\\", "\\\\textbackslash") + " \\\\\n";
        }
        string = string + "\\end{tabular}\n";
        string = string + "}\n";
        string = string + "\\end{table}\n";
        return string;
    }

    public String toStringSummary() {
        int n;
        if (this.m_NonSigWins == null) {
            return "-summary data not set-";
        }
        int n2 = 1 + Math.max((int)(Math.log(this.getColCount()) / Math.log(10.0)), (int)(Math.log(this.getRowCount()) / Math.log(10.0)));
        String string = "";
        String string2 = "";
        string = string + "{\\centering\n";
        string = string + "\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption}\n";
        string = string + "\\footnotesize\n";
        string = string + "\\begin{tabular}{l";
        for (n = 0; n < this.getColCount(); ++n) {
            if (this.getColHidden(n)) continue;
            string2 = string2 + " &";
            string = string + "c";
            string2 = string2 + ' ' + Utils.padLeft("" + this.getSummaryTitle(n), n2 * 2 + 3);
        }
        string = string + "}\\\\\n\\hline\n";
        string = string + string2 + " \\\\\n\\hline\n";
        for (n = 0; n < this.getColCount(); ++n) {
            if (this.getColHidden(n)) continue;
            for (int i = 0; i < this.getColCount(); ++i) {
                if (this.getColHidden(i)) continue;
                if (i == 0) {
                    string = string + (char)(97 + n % 26);
                }
                string = i == n ? string + " & - " : string + "& " + this.m_NonSigWins[n][i] + " (" + this.m_Wins[n][i] + ") ";
            }
            string = string + "\\\\\n";
        }
        string = string + "\\hline\n\\end{tabular} \\footnotesize \\par\n\\end{table}}";
        return string;
    }

    public String toStringRanking() {
        if (this.m_RankingWins == null) {
            return "-ranking data not set-";
        }
        int n = Math.max(this.m_RankingWins[Utils.maxIndex(this.m_RankingWins)], this.m_RankingLosses[Utils.maxIndex(this.m_RankingLosses)]);
        int n2 = Math.max(2 + (int)(Math.log(n) / Math.log(10.0)), ">-<".length());
        String string = "\\begin{table}[thb]\n\\caption{\\label{labelname}Table Caption}\n\\footnotesize\n{\\centering \\begin{tabular}{rlll}\\\\\n\\hline\n";
        string = string + "Resultset & Wins$-$ & Wins & Losses \\\\\n& Losses & & \\\\\n\\hline\n";
        int[] nArray = Utils.sort(this.m_RankingDiff);
        for (int i = this.getColCount() - 1; i >= 0; --i) {
            int n3 = nArray[i];
            if (this.getColHidden(n3)) continue;
            string = string + "(" + (n3 + 1) + ") & " + Utils.padLeft("" + this.m_RankingDiff[n3], n2) + " & " + Utils.padLeft("" + this.m_RankingWins[n3], n2) + " & " + Utils.padLeft("" + this.m_RankingLosses[n3], n2) + "\\\\\n";
        }
        string = string + "\\hline\n\\end{tabular} \\footnotesize \\par}\n\\end{table}";
        return string;
    }

    public static void main(String[] stringArray) {
        ResultMatrixLatex resultMatrixLatex = new ResultMatrixLatex(3, 3);
        resultMatrixLatex.addHeader("header1", "value1");
        resultMatrixLatex.addHeader("header2", "value2");
        resultMatrixLatex.addHeader("header2", "value3");
        for (int i = 0; i < resultMatrixLatex.getRowCount(); ++i) {
            for (int j = 0; j < resultMatrixLatex.getColCount(); ++j) {
                resultMatrixLatex.setMean(j, i, (i + 1) * j);
                resultMatrixLatex.setStdDev(j, i, (double)(i + 1) * (double)j / 100.0);
                if (i != j) continue;
                if (i % 2 == 1) {
                    resultMatrixLatex.setSignificance(j, i, 1);
                    continue;
                }
                resultMatrixLatex.setSignificance(j, i, 2);
            }
        }
        System.out.println("\n\n--> " + ((ResultMatrix)resultMatrixLatex).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(((ResultMatrix)resultMatrixLatex).toStringHeader() + "\n");
        System.out.println(((ResultMatrix)resultMatrixLatex).toStringMatrix() + "\n");
        System.out.println(((ResultMatrix)resultMatrixLatex).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        resultMatrixLatex.setShowStdDev(true);
        System.out.println(((ResultMatrix)resultMatrixLatex).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        resultMatrixLatex.setPrintColNames(false);
        System.out.println(((ResultMatrix)resultMatrixLatex).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        resultMatrixLatex.setColHidden(1, true);
        System.out.println(((ResultMatrix)resultMatrixLatex).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        resultMatrixLatex.setRowHidden(2, true);
        resultMatrixLatex.setPrintRowNames(false);
        System.out.println(((ResultMatrix)resultMatrixLatex).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        resultMatrixLatex.setMeanPrec(3);
        resultMatrixLatex.setPrintRowNames(false);
        System.out.println(((ResultMatrix)resultMatrixLatex).toStringMatrix());
    }
}

