/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.multivariate;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.multivariate.IMultivariateSsf;

public abstract class AbstractMultivariateSsf
implements IMultivariateSsf {
    @Override
    public void L(int pos, SubMatrix k, SubMatrix lm) {
        this.T(pos, lm);
        DataBlockIterator rows = lm.rows();
        DataBlock row = rows.getData();
        DataBlockIterator krows = k.rows();
        DataBlock krow = krows.getData();
        do {
            for (int v = 0; v < this.getVarsCount(); ++v) {
                double c = krow.get(v);
                if (c == 0.0) continue;
                this.XpZd(pos, v, row, -c);
            }
        } while (rows.next());
    }

    @Override
    public void MT(int pos, SubMatrix M) {
        DataBlockIterator rm = M.rows();
        DataBlock r = rm.getData();
        do {
            this.XT(pos, r);
        } while (rm.next());
    }

    @Override
    public void TM(int pos, SubMatrix M) {
        DataBlockIterator cm = M.columns();
        DataBlock c = cm.getData();
        do {
            this.TX(pos, c);
        } while (cm.next());
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        DataBlockIterator cols = vm.columns();
        DataBlock col = cols.getData();
        do {
            this.TX(pos, col);
        } while (cols.next());
        DataBlockIterator rows = vm.rows();
        DataBlock row = rows.getData();
        do {
            this.TX(pos, row);
        } while (rows.next());
    }

    @Override
    public void Z(int pos, SubMatrix zm) {
        DataBlockIterator rows = zm.rows();
        DataBlock row = rows.getData();
        do {
            this.Z(pos, rows.getPosition(), row);
        } while (rows.next());
    }

    @Override
    public void ZM(int pos, int v, SubMatrix m, DataBlock x) {
        DataBlockIterator cols = m.columns();
        DataBlock col = cols.getData();
        do {
            x.set(cols.getPosition(), this.ZX(pos, v, col));
        } while (cols.next());
    }

    @Override
    public void ZM(int pos, SubMatrix m, SubMatrix zm) {
        DataBlockIterator rzm = zm.rows();
        DataBlock r = rzm.getData();
        do {
            this.ZM(pos, rzm.getPosition(), m, r);
        } while (rzm.next());
    }

    @Override
    public void ZVZ(int pos, SubMatrix v, SubMatrix zvz) {
        int n = this.getVarsCount();
        for (int i = 0; i < n; ++i) {
            zvz.set(i, i, this.ZVZ(pos, i, i, v));
            for (int j = 0; j < i; ++j) {
                zvz.set(i, j, this.ZVZ(pos, i, j, v));
            }
        }
        SymmetricMatrix.fromLower(zvz);
    }

    @Override
    public void ZX(int pos, DataBlock x, DataBlock zx) {
        int n = this.getVarsCount();
        for (int i = 0; i < n; ++i) {
            zx.set(i, this.ZX(pos, i, x));
        }
    }

    @Override
    public boolean hasZ(int pos, int v) {
        return true;
    }

    @Override
    public int getTransitionResCount() {
        return this.getStateDim();
    }

    @Override
    public int getTransitionResDim() {
        return this.getStateDim();
    }

    @Override
    public boolean hasR() {
        return false;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return false;
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        this.fullQ(pos, qm);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
    }

    @Override
    public void W(int pos, SubMatrix wv) {
    }
}

