/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingNode;
import ec.tstoolkit.algorithm.MultiTsData;
import ec.tstoolkit.algorithm.MultiTsDataProcessing;
import ec.tstoolkit.algorithm.SingleTsData;
import ec.tstoolkit.algorithm.SingleTsDataProcessing;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.Map;

public class DefaultProcessingFactory {
    public static IProcessingNode<TsData> createInitialStep(final TsPeriodSelector selector) {
        return new IProcessingNode<TsData>(){

            @Override
            public String getName() {
                return "input";
            }

            @Override
            public String getPrefix() {
                return null;
            }

            @Override
            public IProcessing.Status process(TsData input, Map<String, IProcResults> results) {
                SingleTsDataProcessing processing = new SingleTsDataProcessing(selector);
                SingleTsData rslt = processing.process(input);
                if (rslt != null) {
                    results.put("input", rslt);
                    return IProcessing.Status.Valid;
                }
                return IProcessing.Status.Invalid;
            }
        };
    }

    public static IProcessingNode<TsData> createInitialStep(final TsPeriodSelector selector, final SingleTsDataProcessing.Validation validation) {
        return new IProcessingNode<TsData>(){

            @Override
            public String getName() {
                return "input";
            }

            @Override
            public String getPrefix() {
                return null;
            }

            @Override
            public IProcessing.Status process(TsData input, Map<String, IProcResults> results) {
                SingleTsDataProcessing processing = new SingleTsDataProcessing(selector);
                processing.setValidation(validation);
                SingleTsData rslt = processing.process(input);
                if (rslt != null) {
                    results.put("input", rslt);
                    return IProcessing.Status.Valid;
                }
                return IProcessing.Status.Invalid;
            }
        };
    }

    public static IProcessingNode<TsData[]> createInitialStep(final TsPeriodSelector selector, final MultiTsDataProcessing.Validation validation) {
        return new IProcessingNode<TsData[]>(){

            @Override
            public String getName() {
                return "input";
            }

            @Override
            public String getPrefix() {
                return null;
            }

            @Override
            public IProcessing.Status process(TsData[] input, Map<String, IProcResults> results) {
                MultiTsDataProcessing processing = new MultiTsDataProcessing(selector);
                processing.setValidation(validation);
                MultiTsData rslt = processing.process(input);
                if (rslt != null) {
                    results.put("input", rslt);
                    return IProcessing.Status.Valid;
                }
                return IProcessing.Status.Invalid;
            }
        };
    }
}

