/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel.codon;

import dr.evolution.datatype.Codons;
import dr.evomodel.substmodel.AbstractPCARateMatrix;
import dr.evomodel.substmodel.BaseSubstitutionModel;
import dr.evomodel.substmodel.DefaultEigenSystem;
import dr.evomodel.substmodel.EigenSystem;
import dr.evomodel.substmodel.FrequencyModel;
import dr.inference.model.Parameter;

public class PCACodonModel
extends BaseSubstitutionModel {
    protected AbstractPCARateMatrix rateMatrix;
    protected byte[] rateMap;
    protected Parameter pcFactors;

    public PCACodonModel(Codons codons, AbstractPCARateMatrix abstractPCARateMatrix, Parameter parameter, FrequencyModel frequencyModel) {
        this(codons, abstractPCARateMatrix, parameter, frequencyModel, new DefaultEigenSystem(codons.getStateCount()));
    }

    public PCACodonModel(Codons codons, AbstractPCARateMatrix abstractPCARateMatrix, Parameter parameter, FrequencyModel frequencyModel, EigenSystem eigenSystem) {
        super("pcaCodonModel", codons, frequencyModel, eigenSystem);
        int n;
        this.rateMatrix = abstractPCARateMatrix;
        this.pcFactors = parameter;
        this.addVariable(this.pcFactors);
        this.pcFactors.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, this.pcFactors.getDimension()));
        double[] dArray = abstractPCARateMatrix.getStartFacs();
        double d = 0.0;
        for (n = 0; n < this.pcFactors.getDimension(); ++n) {
            d += dArray[n];
        }
        for (n = 0; n < this.pcFactors.getDimension(); ++n) {
            this.pcFactors.setParameterValueQuietly(n, dArray[n] / d);
        }
    }

    @Override
    public void setupRelativeRates(double[] dArray) {
        int n;
        double[] dArray2 = this.rateMatrix.getMeans();
        double[] dArray3 = this.rateMatrix.getScales();
        for (n = 0; n < this.rateCount; ++n) {
            dArray[n] = dArray2[n];
        }
        for (n = 0; n < this.pcFactors.getDimension(); ++n) {
            double[] dArray4 = this.rateMatrix.getPCAt(n);
            double d = this.getPcFactor(n);
            for (int i = 0; i < this.rateCount; ++i) {
                int n2 = i;
                dArray[n2] = dArray[n2] + d * dArray4[i] * dArray3[i];
            }
        }
        for (n = 0; n < this.rateCount; ++n) {
            if (!(dArray[n] < Double.MIN_VALUE)) continue;
            dArray[n] = Double.MIN_VALUE;
        }
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected void frequenciesChanged() {
    }

    public double getPcFactor(int n) {
        return this.pcFactors.getParameterValue(n);
    }

    public double[] getPcFactor() {
        return this.pcFactors.getParameterValues();
    }

    public void setPcFactor(int n, double d) {
        this.pcFactors.setParameterValue(n, d);
        this.updateMatrix = true;
    }

    public void setPcFactor(double[] dArray) {
        for (int i = 0; i < this.pcFactors.getDimension(); ++i) {
            this.pcFactors.setParameterValue(i, dArray[i]);
        }
        this.updateMatrix = true;
    }

    public String toXHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<em>PCA Codon Model</em>");
        return stringBuffer.toString();
    }
}

