/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ucarima.estimation;

import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.FastArimaForecasts;
import ec.tstoolkit.arima.estimation.FastArimaML;
import ec.tstoolkit.arima.estimation.SemiInfiniteSampleForecast;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.ucarima.UcarimaModel;
import ec.tstoolkit.ucarima.WienerKolmogorovEstimators;

@Deprecated
public class BurmanEstimates {
    private double[] m_data;
    private int m_nf;
    private WienerKolmogorovEstimators m_wk;
    private Polynomial m_ar;
    private Polynomial m_ma;
    private Polynomial[] m_g;
    private double m_ser;
    private int m_nparams;
    private double[][] m_e;
    private double[][] m_f;
    private double[] m_xb;
    private double[] m_xf;
    private double[] m_res;
    private double[] m_bres;
    private double m_fwm;
    private double m_bwm;
    private boolean m_bmean;
    private double m_meancorrection;

    protected void calc(int cmp) {
        int i;
        int i2;
        int j;
        double s;
        int i3;
        int i4;
        int j2;
        int i5;
        if (this.m_e[cmp] != null || this.m_data == null) {
            return;
        }
        if (this.m_g[cmp] == null) {
            if (cmp == 0 && this.m_bmean) {
                int i6;
                this.m_e[cmp] = new double[this.m_data.length];
                for (i6 = 0; i6 < this.m_data.length; ++i6) {
                    this.m_e[cmp][i6] = this.m_meancorrection;
                }
                this.m_f[cmp] = new double[this.m_nf];
                for (i6 = 0; i6 < this.m_nf; ++i6) {
                    this.m_f[cmp][i6] = this.m_meancorrection;
                }
            }
            return;
        }
        this.extendSeries();
        int n = this.m_data.length;
        int nf = this.m_xf.length;
        int nr = this.m_g[cmp].getDegree();
        Polynomial ma = this.m_ma;
        Polynomial ar = this.m_ar;
        int qstar = ma.getDegree();
        int pstar = ar.getDegree();
        double[] z = new double[n + 2 * nf];
        for (int i7 = 0; i7 < n; ++i7) {
            z[i7 + nf] = this.m_data[i7];
        }
        int ntmp = nf + n;
        for (i5 = 0; i5 < nf; ++i5) {
            z[ntmp + i5] = this.m_xf[i5];
        }
        ntmp = nf - 1;
        for (i5 = 0; i5 < nf; ++i5) {
            z[ntmp - i5] = this.m_xb[i5];
        }
        if (this.m_meancorrection != 0.0) {
            i5 = 0;
            while (i5 < z.length) {
                int n2 = i5++;
                z[n2] = z[n2] - this.m_meancorrection;
            }
        }
        double[] w = new double[n + qstar];
        Polynomial g = this.m_g[cmp];
        for (int i8 = 0; i8 < n + qstar; ++i8) {
            double s2 = g.get(0) * z[nf + i8];
            for (j2 = 1; j2 <= nr; ++j2) {
                s2 += g.get(j2) * z[nf + i8 + j2];
            }
            w[i8] = s2;
        }
        Matrix m = new Matrix(pstar + qstar, pstar + qstar);
        double[] ww = new double[pstar + qstar];
        ntmp = n + qstar - pstar;
        for (i4 = 0; i4 < pstar; ++i4) {
            ww[i4] = w[ntmp + i4];
            for (j2 = 0; j2 <= qstar; ++j2) {
                m.set(i4, i4 + j2, ma.get(j2));
            }
        }
        for (i4 = 0; i4 < qstar; ++i4) {
            if (this.m_bmean && cmp == 0 && this.m_meancorrection == 0.0) {
                ww[i4 + pstar] = this.m_fwm / 2.0;
            }
            for (j2 = 0; j2 <= pstar; ++j2) {
                m.set(i4 + pstar, i4 + j2, ar.get(pstar - j2));
            }
        }
        Householder qr = new Householder(false);
        qr.setEpsilon(1.0E-30);
        qr.decompose(m);
        double[] mx = qr.solve(ww);
        int nx1 = n + Math.max(2 * qstar, nf);
        double[] x1 = new double[nx1];
        ntmp = n + qstar - pstar;
        for (i3 = 0; i3 < pstar + qstar; ++i3) {
            x1[ntmp + i3] = mx[i3];
        }
        for (i3 = ntmp - 1; i3 >= 0; --i3) {
            s = w[i3];
            for (j = 1; j <= qstar; ++j) {
                s -= x1[i3 + j] * ma.get(j);
            }
            x1[i3] = s;
        }
        for (i3 = ntmp + pstar + qstar; i3 < nx1; ++i3) {
            s = 0.0;
            for (j = 1; j <= pstar; ++j) {
                s -= ar.get(j) * x1[i3 - j];
            }
            x1[i3] = s;
        }
        double[] w2 = new double[n + nf + qstar];
        for (i2 = 0; i2 < n + nf + qstar; ++i2) {
            double s3 = g.get(0) * z[nf - qstar + i2];
            for (int j3 = 1; j3 <= nr; ++j3) {
                s3 += g.get(j3) * z[nf - qstar + i2 - j3];
            }
            w2[i2] = s3;
        }
        for (i2 = 0; i2 < pstar; ++i2) {
            ww[i2] = w2[pstar - i2 - 1];
        }
        if (this.m_bmean && cmp == 0 && this.m_meancorrection == 0.0) {
            for (i2 = pstar; i2 < ww.length; ++i2) {
                ww[i2] = this.m_bwm / 2.0;
            }
        }
        mx = qr.solve(ww);
        int nx2 = n + 2 * qstar + Math.max(nf, 2 * qstar);
        double[] x2 = new double[nx2];
        for (i = 0; i < pstar + qstar; ++i) {
            x2[pstar + qstar - 1 - i] = mx[i];
        }
        for (i = pstar + qstar; i < nx2; ++i) {
            double s4 = w2[i - qstar];
            for (int j4 = 1; j4 <= qstar; ++j4) {
                s4 -= x2[i - j4] * ma.get(j4);
            }
            x2[i] = s4;
        }
        double[] rslt = new double[n];
        for (int i9 = 0; i9 < n; ++i9) {
            rslt[i9] = x1[i9] + x2[i9 + 2 * qstar];
        }
        this.m_e[cmp] = rslt;
        if (this.m_nf > 0) {
            double[] fcast = new double[this.m_nf];
            for (int i10 = 0; i10 < this.m_nf; ++i10) {
                fcast[i10] = x1[n + i10] + x2[n + i10 + 2 * qstar];
            }
            this.m_f[cmp] = fcast;
        }
        if (this.m_meancorrection != 0.0 && cmp == 0 && this.m_bmean) {
            int i11 = 0;
            while (i11 < this.m_e[cmp].length) {
                double[] dArray = this.m_e[cmp];
                int n3 = i11++;
                dArray[n3] = dArray[n3] + this.m_meancorrection;
            }
            if (this.m_nf > 0) {
                i11 = 0;
                while (i11 < this.m_f[cmp].length) {
                    double[] dArray = this.m_f[cmp];
                    int n4 = i11++;
                    dArray[n4] = dArray[n4] + this.m_meancorrection;
                }
            }
        }
    }

    protected void clearForecasts() {
        this.m_xb = null;
        this.m_xf = null;
        if (this.m_f != null) {
            for (int i = 0; i < this.m_f.length; ++i) {
                this.m_f[i] = null;
            }
        }
    }

    protected void clearResults() {
        this.m_bres = null;
        this.m_res = null;
        this.m_fwm = 0.0;
        this.m_bwm = 0.0;
        this.m_meancorrection = 0.0;
        this.m_ser = 0.0;
        if (this.m_e != null) {
            for (int i = 0; i < this.m_e.length; ++i) {
                this.m_e[i] = null;
            }
        }
    }

    public double[] estimates(int cmp, boolean signal) {
        this.calc(cmp);
        if (signal) {
            return this.m_e[cmp];
        }
        double[] e = new double[this.m_data.length];
        for (int i = 0; i < e.length; ++i) {
            e[i] = this.m_data[i] - this.m_e[cmp][i];
        }
        return e;
    }

    private void extendSeries() {
        if (this.m_xb != null) {
            return;
        }
        int nf = 0;
        for (int i = 0; i < this.m_g.length; ++i) {
            int nr = 0;
            if (this.m_g[i] != null) {
                nr = this.m_g[i].getDegree();
            }
            if (this.m_ma != null) {
                nr += this.m_ma.getDegree();
            }
            if (this.m_bmean) {
                nr += 2;
            }
            if (nr <= nf) continue;
            nf = nr;
        }
        if (this.m_nf > nf) {
            nf = this.m_nf;
        }
        FastArimaForecasts fcast = new FastArimaForecasts(this.m_wk.getUcarimaModel().getModel(), this.m_bmean);
        this.m_xf = fcast.forecasts(new DataBlock(this.m_data), nf);
        this.m_fwm = fcast.getMean();
        this.m_xb = fcast.forecasts(new DataBlock(this.m_data).reverse(), nf);
        this.m_bwm = fcast.getMean();
        this.m_meancorrection = 0.0;
        if (this.m_bmean) {
            BackFilter ur = this.m_wk.getUcarimaModel().getComponent(0).getNonStationaryAR();
            BackFilter ar = this.m_wk.getUcarimaModel().getComponent(0).getStationaryAR();
            BackFilter mar = this.m_wk.getUcarimaModel().getModel().getStationaryAR();
            if (Math.abs(ur.getPolynomial().evaluateAt(1.0)) > Polynomial.getEpsilon()) {
                for (int i = 0; i < this.m_data.length; ++i) {
                    this.m_meancorrection += this.m_data[i];
                }
                this.m_meancorrection /= (double)this.m_data.length;
                this.m_bwm = 0.0;
                this.m_fwm = 0.0;
            } else {
                BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool(true);
                if (smp.simplify(ar, mar) && ((BackFilter)smp.getLeft()).getLength() > 1) {
                    double z = ((BackFilter)smp.getLeft()).getPolynomial().evaluateAt(1.0);
                    this.m_bwm *= z;
                    this.m_fwm *= z;
                }
            }
        }
    }

    private void extendSeriesOld() {
        if (this.m_xb != null) {
            return;
        }
        int nf = 0;
        for (int i = 0; i < this.m_g.length; ++i) {
            int nr = this.m_ma.getDegree();
            if (this.m_g[i] != null) {
                nr += this.m_g[i].getDegree();
            }
            if (nr <= nf) continue;
            nf = nr;
        }
        if (this.m_nf > nf) {
            nf = this.m_nf;
        }
        int n = this.m_data.length;
        double[] xb = new double[n];
        FastArimaML fml = new FastArimaML();
        SemiInfiniteSampleForecast fcast = new SemiInfiniteSampleForecast();
        IArimaModel model = this.m_wk.getUcarimaModel().getModel();
        fml.setModel(model);
        fml.setMeanCorrection(this.m_bmean);
        fcast.setModel(model);
        fcast.setForecastHorizon(nf);
        fml.process(new DataBlock(this.m_data));
        this.m_ser = fml.ser(this.m_nparams);
        this.m_res = fml.getResiduals();
        this.m_fwm = fml.getDMean();
        fcast.process(this.m_data, this.m_res, fml.getDMean(), fml.ser(this.m_nparams));
        this.m_xf = fcast.getForecasts();
        int ntmp = n - 1;
        for (int i = 0; i <= ntmp; ++i) {
            xb[ntmp - i] = this.m_data[i];
        }
        fml.process(new DataBlock(xb));
        this.m_bres = fml.getResiduals();
        this.m_bwm = fml.getDMean();
        fcast.process(xb, this.m_bres, fml.getDMean(), fml.ser(this.m_nparams));
        this.m_xb = fcast.getForecasts();
        this.m_meancorrection = 0.0;
        if (this.m_bmean) {
            BackFilter ar = this.m_wk.getUcarimaModel().getComponent(0).getAR();
            BackFilter mar = model.getAR();
            if (Math.abs(ar.getPolynomial().evaluateAt(1.0)) > Polynomial.getEpsilon()) {
                for (int i = 0; i < this.m_data.length; ++i) {
                    this.m_meancorrection += this.m_data[i];
                }
                this.m_meancorrection /= (double)this.m_data.length;
                this.m_bwm = 0.0;
                this.m_fwm = 0.0;
            } else {
                BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool(true);
                if (smp.simplify(ar, mar) && ((BackFilter)smp.getLeft()).getLength() > 1) {
                    double z = ((BackFilter)smp.getLeft()).getPolynomial().evaluateAt(1.0);
                    this.m_bwm *= z;
                    this.m_fwm *= z;
                }
            }
        }
    }

    public double[] forecasts(int cmp, boolean signal) {
        this.calc(cmp);
        if (signal) {
            return this.m_f[cmp];
        }
        double[] f = new double[this.m_nf];
        for (int i = 0; i < f.length; ++i) {
            f[i] = this.m_xf[i] - this.m_f[cmp][i];
        }
        return f;
    }

    public double[] getBackResiduals() {
        return this.m_bres;
    }

    public double[] getData() {
        return this.m_data;
    }

    public WienerKolmogorovEstimators getEstimators() {
        return this.m_wk;
    }

    public int getForecastsCount() {
        return this.m_nf;
    }

    public int getHyperParametersCount() {
        return this.m_nparams;
    }

    public double getMean() {
        return this.m_meancorrection;
    }

    public double[] getResiduals() {
        return this.m_res;
    }

    public double getSer() {
        return this.m_ser;
    }

    public double[] getBackcasts() {
        this.extendSeries();
        return this.m_xb;
    }

    public double[] getForecasts() {
        this.extendSeries();
        return this.m_xf;
    }

    public UcarimaModel getUcarimaModel() {
        return this.m_wk.getUcarimaModel();
    }

    private void initModel() {
        UcarimaModel ucm = this.m_wk.getUcarimaModel();
        IArimaModel model = ucm.getModel();
        int ncmps = ucm.getComponentsCount();
        this.m_e = new double[ncmps][];
        this.m_f = new double[ncmps][];
        this.m_g = new Polynomial[ncmps];
        this.m_ma = model.getMA().getPolynomial();
        this.m_ar = model.getAR().getPolynomial();
        for (int i = 0; i < ncmps; ++i) {
            BackFilter scar;
            ArimaModel cmp = ucm.getComponent(i);
            if (cmp.isNull()) continue;
            BackFilter umar = model.getNonStationaryAR();
            BackFilter ucar = cmp.getNonStationaryAR();
            BackFilter nar = umar.divide(ucar);
            BackFilter.SimplifyingTool smp = new BackFilter.SimplifyingTool(false);
            BackFilter smar = model.getStationaryAR();
            if (smp.simplify(smar, scar = cmp.getStationaryAR())) {
                smar = (BackFilter)smp.getLeft();
                scar = (BackFilter)smp.getRight();
            }
            BackFilter dar = scar;
            nar = nar.times(smar);
            BackFilter denom = new BackFilter(this.m_ma).times(dar);
            SymmetricFilter c = cmp.sma().times(SymmetricFilter.createFromFilter(nar));
            double mvar = model.getInnovationVariance();
            if (mvar != 1.0) {
                c = c.times(1.0 / mvar);
            }
            BackFilter gf = c.decompose(denom);
            this.m_g[i] = gf.getPolynomial();
        }
    }

    public boolean isMeanCorrection() {
        return this.m_bmean;
    }

    public void setData(double[] value) {
        this.m_data = (double[])value.clone();
        this.clearResults();
        this.clearForecasts();
    }

    public void setData(IReadDataBlock data) {
        this.m_data = new double[data.getLength()];
        data.copyTo(this.m_data, 0);
        this.clearResults();
        this.clearForecasts();
    }

    public void setEstimators(WienerKolmogorovEstimators value) {
        this.m_wk = value;
        this.initModel();
        this.clearResults();
        this.clearForecasts();
    }

    public void setForecastsCount(int value) {
        this.m_nf = value;
        this.clearForecasts();
    }

    public void setHyperParametersCount(int value) {
        this.m_nparams = value;
    }

    public void setMeanCorrection(boolean value) {
        if (this.m_bmean != value) {
            this.m_bmean = value;
            this.clearResults();
        }
    }

    public void setUcarimaModel(UcarimaModel value) {
        this.m_wk = new WienerKolmogorovEstimators(value);
        this.initModel();
        this.clearResults();
        this.clearForecasts();
    }

    public double[] stdevEstimates(int cmp) {
        this.calc(cmp);
        if (this.m_wk.getUcarimaModel().getComponent(cmp).isNull()) {
            return new double[this.m_data.length];
        }
        int n = (this.m_data.length + 1) / 2;
        double[] err = this.m_wk.totalErrorVariance(cmp, true, 0, n);
        double[] e = new double[this.m_data.length];
        for (int i = 0; i < err.length; ++i) {
            double x;
            e[i] = x = this.m_ser * Math.sqrt(err[i]);
            e[e.length - i - 1] = x;
        }
        return e;
    }

    public double[] stdevForecasts(int cmp, boolean signal) {
        this.calc(cmp);
        if (this.m_wk.getUcarimaModel().getComponent(cmp).isNull()) {
            if (signal) {
                return new double[this.m_nf];
            }
            return null;
        }
        double[] e = this.m_wk.totalErrorVariance(cmp, signal, -this.m_nf, this.m_nf);
        double[] err = new double[this.m_nf];
        for (int i = 0; i < this.m_nf; ++i) {
            err[i] = this.m_ser * Math.sqrt(e[this.m_nf - 1 - i]);
        }
        return err;
    }

    public void setSer(double ser) {
        this.m_ser = ser;
    }
}

