/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ucarima;

import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.polynomials.AbstractRootSelector;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.UnitRoots;

public class TrendCycleSelector
extends AbstractRootSelector {
    private double m_bound = 0.5;
    private double m_lfreq = 0.0;

    public TrendCycleSelector() {
    }

    public TrendCycleSelector(double bound) {
        this.m_bound = bound;
    }

    public double getLowFreqThreshold() {
        return this.m_lfreq;
    }

    public void setLowFreqThreshold(double val) {
        this.m_lfreq = val * Math.PI / 180.0;
    }

    public void setDefaultLowFreqThreshold(int freq) {
        this.m_lfreq = Math.PI / (double)freq - 1.0E-6;
    }

    @Override
    public boolean accept(Complex root) {
        double arg;
        Complex iroot = root.inv();
        if (root.getIm() == 0.0) {
            return iroot.getRe() >= this.m_bound;
        }
        return iroot.abs() >= this.m_bound && (arg = Math.abs(iroot.arg())) <= this.m_lfreq;
    }

    public double getBound() {
        return this.m_bound;
    }

    public void setBound(double value) {
        this.m_bound = value;
    }

    @Override
    public boolean selectUnitRoots(Polynomial p) {
        Polynomial.Division div;
        this.m_sel = Polynomial.ONE;
        this.m_nsel = p;
        Polynomial D = UnitRoots.D1;
        while ((div = Polynomial.divide(this.m_nsel, D)).isExact()) {
            this.m_sel = this.m_sel.times(D);
            this.m_nsel = div.getQuotient();
            if (p.getDegree() > 1) continue;
        }
        return this.m_sel.getDegree() > 0;
    }
}

