/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.IUserTsVariable;
import ec.tstoolkit.timeseries.regression.TsVariable;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.List;

public class TsVariableGroup
implements IUserTsVariable {
    private final ITsVariable[] vars_;
    private final String desc_;
    private String name;

    public TsVariableGroup(String desc, ITsVariable[] vars) {
        this.desc_ = desc;
        this.vars_ = vars;
    }

    public TsVariableGroup(String desc, TsData[] vars) {
        this.desc_ = desc;
        this.vars_ = new ITsVariable[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            this.vars_[i] = new TsVariable(vars[i]);
        }
    }

    @Override
    public void data(TsDomain domain, List<DataBlock> data) {
        int n0 = 0;
        for (int i = 0; i < this.vars_.length; ++i) {
            int n1 = n0 + this.vars_[i].getDim();
            this.vars_[i].data(domain, data.subList(n0, n1));
            n0 = n1;
        }
    }

    @Override
    public TsDomain getDefinitionDomain() {
        TsDomain domain = null;
        for (int i = 0; i < this.vars_.length; ++i) {
            TsDomain d = this.vars_[i].getDefinitionDomain();
            if (d == null) continue;
            domain = domain == null ? d : d.intersection(domain);
        }
        return domain;
    }

    @Override
    public TsFrequency getDefinitionFrequency() {
        TsFrequency freq = TsFrequency.Undefined;
        for (int i = 0; i < this.vars_.length; ++i) {
            TsFrequency f = this.vars_[i].getDefinitionFrequency();
            if (f == TsFrequency.Undefined) continue;
            if (freq == TsFrequency.Undefined) {
                freq = f;
                continue;
            }
            if (freq == f) continue;
            throw new TsException("Incompatible frequencies");
        }
        return freq;
    }

    @Override
    public String getDescription(TsFrequency context) {
        return this.desc_ == null ? "" : this.desc_;
    }

    @Override
    public int getDim() {
        int n = 0;
        for (int i = 0; i < this.vars_.length; ++i) {
            n += this.vars_[i].getDim();
        }
        return n;
    }

    @Override
    public String getItemDescription(int idx, TsFrequency context) {
        int cur = idx;
        for (int i = 0; i < this.vars_.length; ++i) {
            int dim = this.vars_[i].getDim();
            if (cur < dim) {
                return this.vars_[i].getItemDescription(cur, context);
            }
            cur -= dim;
        }
        return "";
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        for (int i = 0; i < this.vars_.length; ++i) {
            if (this.vars_[i].isSignificant(domain)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        int n = this.getDim();
        if (n == 1) {
            return this.desc_ == null ? "vars" : this.name;
        }
        return (this.desc_ == null ? "vars#" : this.name + '#') + n;
    }

    public void setName(String name) {
        this.name = name;
    }
}

