/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.AbstractTsModifier;
import ec.tstoolkit.timeseries.regression.ChangeOfRegimeType;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class ChangeOfRegime
extends AbstractTsModifier {
    private final ChangeOfRegimeType regime;
    private final Day day;

    public ChangeOfRegime(ITsVariable var, ChangeOfRegimeType regime, Day day) {
        super(var);
        this.regime = regime;
        this.day = day;
    }

    @Override
    public void data(TsDomain domain, List<DataBlock> data) {
        TsPeriod pos = new TsPeriod(domain.getFrequency());
        pos.set(this.day);
        int ipos = pos.minus(domain.getStart());
        int n = domain.getLength();
        int m = this.var.getDim();
        if (this.regime == ChangeOfRegimeType.ZeroEnded) {
            if (ipos >= n) {
                this.var.data(domain, data);
            } else if (ipos < 0) {
                for (int i = 0; i < this.var.getDim(); ++i) {
                    data.get(i).set(0.0);
                }
            } else {
                ArrayList<DataBlock> tmp = new ArrayList<DataBlock>();
                for (int i = 0; i < m; ++i) {
                    DataBlock rc = data.get(i);
                    tmp.add(rc.range(0, ipos));
                    rc.range(ipos, n).set(0.0);
                }
                this.var.data(domain.drop(0, n - ipos), tmp);
            }
        } else if (ipos >= n) {
            for (int i = 0; i < m; ++i) {
                data.get(i).set(0.0);
            }
        } else if (ipos < 0) {
            this.var.data(domain, data);
        } else {
            ArrayList<DataBlock> tmp = new ArrayList<DataBlock>();
            for (int i = 0; i < m; ++i) {
                DataBlock rc = data.get(i);
                tmp.add(rc.range(ipos, n));
                rc.range(0, ipos).set(0.0);
            }
            this.var.data(domain.drop(ipos, 0), tmp);
        }
    }

    private String description(String desc, TsFrequency freq) {
        StringBuilder builder = new StringBuilder();
        builder.append(desc);
        if (this.regime == ChangeOfRegimeType.ZeroEnded) {
            builder.append("(/");
            if (freq == TsFrequency.Undefined) {
                builder.append(this.day);
            } else {
                TsPeriod p = new TsPeriod(freq, this.day);
                builder.append(p);
            }
            builder.append("//)");
        } else {
            builder.append("(//");
            if (freq == TsFrequency.Undefined) {
                builder.append(this.day);
            } else {
                TsPeriod p = new TsPeriod(freq, this.day);
                builder.append(p);
            }
            builder.append("/)");
        }
        return builder.toString();
    }

    public Day getDay() {
        return this.day;
    }

    @Override
    public TsDomain getDefinitionDomain() {
        return this.var.getDefinitionDomain();
    }

    @Override
    public TsFrequency getDefinitionFrequency() {
        return this.var.getDefinitionFrequency();
    }

    @Override
    public String getDescription(TsFrequency context) {
        return this.description(this.var.getDescription(context), context);
    }

    @Override
    public int getDim() {
        return this.var.getDim();
    }

    @Override
    public String getItemDescription(int idx, TsFrequency context) {
        return this.description(this.var.getItemDescription(idx, context), context);
    }

    public ChangeOfRegimeType getRegime() {
        return this.regime;
    }

    @Override
    public ITsVariable getVariable() {
        return this.var;
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        TsPeriod p = new TsPeriod(domain.getFrequency());
        p.set(this.day);
        if (this.regime == ChangeOfRegimeType.ZeroEnded) {
            if (p.isNotAfter(domain.getStart())) {
                return false;
            }
            if (p.isAfter(domain.getLast())) {
                return this.var.isSignificant(domain);
            }
            int pos = domain.search(p);
            TsDomain domc = domain.drop(0, domain.getLength() - pos);
            return this.var.isSignificant(domc);
        }
        if (p.isNotAfter(domain.getStart())) {
            return this.var.isSignificant(domain);
        }
        if (p.isAfter(domain.getLast())) {
            return false;
        }
        int pos = domain.search(p);
        TsDomain domc = domain.drop(pos, 0);
        return this.var.isSignificant(domc);
    }

    @Override
    public String getName() {
        String name = this.var.getName();
        int pos = name.indexOf(35);
        String sname = name;
        String suffix = null;
        if (pos >= 0) {
            sname = name.substring(0, pos);
            suffix = name.substring(pos);
        }
        StringBuilder builder = new StringBuilder();
        if (this.regime == ChangeOfRegimeType.ZeroEnded) {
            builder.append(sname);
            builder.append("//)");
        } else {
            builder.append("(//");
            builder.append(sname);
        }
        if (suffix != null) {
            builder.append(suffix);
        }
        return builder.toString();
    }
}

