/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.AbstractSingleTsVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.Arrays;

public abstract class AbstractOutlierVariable
extends AbstractSingleTsVariable
implements IOutlierVariable {
    protected final Day position;

    @Deprecated
    public static double mad(double[] data, boolean medcorrection) {
        double[] e = (double[])data.clone();
        return AbstractOutlierVariable.calcmad(e, medcorrection);
    }

    @Deprecated
    public static double mad(IReadDataBlock data, boolean medcorrection) {
        double[] e = new double[data.getLength()];
        data.copyTo(e, 0);
        return AbstractOutlierVariable.calcmad(e, medcorrection);
    }

    @Deprecated
    private static double calcmad(double[] e, boolean medcorrection) {
        Arrays.sort(e);
        int n = e.length;
        double median = 0.0;
        int n2 = n / 2;
        median = n2 * 2 == n ? (e[n2 - 1] + e[n2]) / 2.0 : e[n2];
        if (medcorrection) {
            for (int i = 0; i < n; ++i) {
                if (e[i] >= median) {
                    int n3 = i;
                    e[n3] = e[n3] - median;
                    continue;
                }
                e[i] = median - e[i];
            }
        }
        Arrays.sort(e);
        median = n2 * 2 == n ? (e[n2 - 1] + e[n2]) / 2.0 : e[n2];
        return 1.483 * median;
    }

    protected AbstractOutlierVariable(Day pos) {
        this.position = pos;
    }

    @Override
    public String getDescription(TsFrequency context) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getCode()).append(" (");
        if (context == TsFrequency.Undefined) {
            builder.append(this.position);
        } else {
            TsPeriod p = new TsPeriod(context, this.position);
            builder.append(p);
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public Day getPosition() {
        return this.position;
    }
}

