/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.calendars;

import ec.tstoolkit.timeseries.calendars.ISpecialDay;
import ec.tstoolkit.timeseries.calendars.SpecialDayEvent;
import ec.tstoolkit.utilities.Comparator;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class NationalCalendar
implements Cloneable {
    private List<SpecialDayEvent> m_sd = new ArrayList<SpecialDayEvent>();
    private final ISpecialDay.Context context;

    public NationalCalendar() {
        this(true, false);
    }

    public NationalCalendar(boolean mean, boolean julianeaster) {
        this.context = new ISpecialDay.Context(mean, julianeaster);
    }

    public ISpecialDay.Context getContext() {
        return this.context;
    }

    public boolean add(ISpecialDay fday) {
        if (fday.match(this.context)) {
            this.m_sd.add(new SpecialDayEvent(fday));
            return true;
        }
        return false;
    }

    public int getCount() {
        return this.m_sd.size();
    }

    public boolean add(SpecialDayEvent sd) {
        if (!sd.day.match(this.context)) {
            return false;
        }
        for (SpecialDayEvent ev : this.m_sd) {
            if (!ev.equals((Object)sd)) continue;
            return false;
        }
        this.m_sd.add(sd);
        return true;
    }

    public void addAll(Collection<SpecialDayEvent> c) {
        for (SpecialDayEvent nev : c) {
            if (!nev.day.match(this.context)) continue;
            boolean used = false;
            for (SpecialDayEvent ev : this.m_sd) {
                if (!ev.equals((Object)nev)) continue;
                used = true;
                break;
            }
            if (used) continue;
            this.m_sd.add(nev);
        }
    }

    public SpecialDayEvent get(int idx) {
        return this.m_sd.get(idx);
    }

    public void clear() {
        this.m_sd.clear();
    }

    public SpecialDayEvent[] toArray() {
        return Jdk6.Collections.toArray(this.m_sd, SpecialDayEvent.class);
    }

    public NationalCalendar clone() {
        try {
            NationalCalendar cal = (NationalCalendar)super.clone();
            cal.m_sd = Jdk6.newArrayList(this.m_sd);
            return cal;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public Collection<SpecialDayEvent> elements() {
        return Collections.unmodifiableList(this.m_sd);
    }

    public boolean contentEquals(NationalCalendar other) {
        return Objects.deepEquals(this.context, other.context) && Comparator.equals(this.m_sd, other.m_sd);
    }
}

