/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.analysis;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.information.ParameterInfo;
import ec.tstoolkit.information.RegressionItem;
import ec.tstoolkit.timeseries.analysis.IDoubleFormatter;
import ec.tstoolkit.timeseries.analysis.ITsProcessing;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.lang.reflect.Type;
import java.util.HashMap;

public class MovingProcessingFacade<T extends IProcResults> {
    private ITsProcessing<T> processing;
    private HashMap<TsDomain, T> m_cache = new HashMap();
    private TsDomain m_domainT;
    private static final int g_nyears = 8;
    private int m_increment;
    private int m_length;
    private TsPeriod m_start;
    private static HashMap<Type, IDoubleFormatter> dictionary = new HashMap();

    public MovingProcessingFacade(ITsProcessing<T> processing, TsDomain domain) {
        this.processing = processing;
        this.m_domainT = domain;
        this.m_cache.put(this.m_domainT, processing.process(this.m_domainT));
        this.m_start = this.m_domainT.getStart();
        this.m_increment = this.m_domainT.getFrequency().intValue();
        this.m_length = this.m_increment * 8;
        dictionary.put((Type)((Object)Double.class), new DoubleFormatter());
        dictionary.put((Type)((Object)Integer.class), new IntegerFormatter());
        dictionary.put((Type)((Object)RegressionItem.class), new RegressionItemFormatter());
        dictionary.put((Type)((Object)Parameter.class), new ParameterFormatter());
        dictionary.put((Type)((Object)ParameterInfo.class), new ParameterInfoFormatter());
    }

    public Double getData(String key, TsDomain domain) {
        Object info = this.tsInfo(domain);
        if (info == null) {
            return null;
        }
        Object o = info.getData(key, Object.class);
        if (o == null) {
            return null;
        }
        return dictionary.get(o.getClass()).getDoubleValue(o);
    }

    public HashMap<TsDomain, T> getCache() {
        return this.m_cache;
    }

    public void setCache(HashMap<TsDomain, T> m_cache) {
        this.m_cache = m_cache;
    }

    public TsDomain getDomain() {
        return this.m_domainT;
    }

    public void setDomain(TsDomain m_domainT) {
        this.m_domainT = m_domainT;
    }

    public int getIncrement() {
        return this.m_increment;
    }

    public void setIncrement(int m_increment) {
        this.m_increment = m_increment;
    }

    public int getLength() {
        return this.m_length;
    }

    public void setLength(int m_length) {
        this.m_length = m_length;
    }

    public TsPeriod getStart() {
        return this.m_start;
    }

    public void setStart(TsPeriod m_start) {
        this.m_start = m_start;
    }

    public ITsProcessing<T> getProcessing() {
        return this.processing;
    }

    public void setProcessing(ITsProcessing<T> processing) {
        this.processing = processing;
    }

    public T tsInfo(TsDomain domain) {
        IProcResults it = (IProcResults)this.m_cache.get(domain);
        if (it == null) {
            it = this.processing.process(domain);
            this.m_cache.put(domain, it);
        }
        return (T)it;
    }

    public TsData referenceSeries(String series) {
        TsData it = this.tsInfo(this.m_domainT);
        if (it == null) {
            return null;
        }
        return it.getData(series, TsData.class);
    }

    private static class ParameterInfoFormatter
    implements IDoubleFormatter {
        private ParameterInfoFormatter() {
        }

        @Override
        public Double getDoubleValue(Object item) {
            ParameterInfo p = (ParameterInfo)item;
            return p == null ? null : Double.valueOf(p.value);
        }
    }

    private static class ParameterFormatter
    implements IDoubleFormatter {
        private ParameterFormatter() {
        }

        @Override
        public Double getDoubleValue(Object item) {
            Parameter p = (Parameter)item;
            return p == null ? null : Double.valueOf(p.getValue());
        }
    }

    private static class DoubleFormatter
    implements IDoubleFormatter {
        private DoubleFormatter() {
        }

        @Override
        public Double getDoubleValue(Object item) {
            Double i = (Double)item;
            return i;
        }
    }

    private static class IntegerFormatter
    implements IDoubleFormatter {
        private IntegerFormatter() {
        }

        @Override
        public Double getDoubleValue(Object item) {
            Integer i = (Integer)item;
            return (double)i;
        }
    }

    private static class RegressionItemFormatter
    implements IDoubleFormatter {
        private RegressionItemFormatter() {
        }

        @Override
        public Double getDoubleValue(Object item) {
            RegressionItem i = (RegressionItem)item;
            return i.coefficient;
        }
    }
}

