/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.stats;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.dstats.F;
import ec.tstoolkit.dstats.Normal;
import ec.tstoolkit.dstats.T;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.stats.StatisticalTest;

public class MeanTest
extends StatisticalTest {
    public static final double SMALL = 1.0E-38;
    private double mean_;
    private double emean_;
    private double var_;
    private int n_;

    public double getExpectedMean() {
        return this.emean_;
    }

    public double getMean() {
        return this.mean_;
    }

    public double getVariance() {
        return this.var_;
    }

    public int getSampleSize() {
        return this.n_;
    }

    public void sampleMean(DescriptiveStatistics stats, double expectedMean, double stdev, TestType alternative) {
        this.n_ = stats.getObservationsCount();
        this.mean_ = stats.getAverage();
        this.var_ = stdev * stdev;
        this.m_val = Math.sqrt(this.n_) * (this.mean_ - expectedMean) / stdev;
        this.m_dist = new Normal();
        this.m_type = alternative;
        this.m_asympt = false;
        this.emean_ = expectedMean;
    }

    public void sampleMean(DescriptiveStatistics stats, double expectedMean, TestType alternative) {
        this.n_ = stats.getObservationsCount();
        this.mean_ = stats.getSum() / (double)(this.n_ - 1);
        this.var_ = stats.getSumSquare() / (double)(this.n_ - 1);
        this.var_ -= this.mean_ * this.mean_;
        if (this.var_ < 1.0E-38) {
            this.var_ = 1.0E-38;
        }
        this.m_val = (this.mean_ - expectedMean) / Math.sqrt(this.var_ / (double)(this.n_ - 1));
        T tstat = new T();
        tstat.setDegreesofFreedom(this.n_ - 1);
        this.m_dist = tstat;
        this.m_type = alternative;
        this.m_asympt = false;
        this.emean_ = expectedMean;
    }

    public void zeroMean(DescriptiveStatistics stats) {
        this.n_ = stats.getObservationsCount();
        this.mean_ = stats.getSum() / (double)this.n_;
        this.var_ = stats.getSumSquare() / (double)this.n_;
        this.m_val = this.mean_ / Math.sqrt(this.var_ / (double)this.n_);
        T tstat = new T();
        tstat.setDegreesofFreedom(this.n_);
        this.m_dist = tstat;
        this.m_type = TestType.TwoSided;
        this.m_asympt = false;
        this.emean_ = 0.0;
    }

    public void sampleMean(IReadDataBlock data, double expectedMean, double stdev, TestType alternative) {
        DescriptiveStatistics bs = new DescriptiveStatistics(data);
        this.sampleMean(bs, expectedMean, stdev, alternative);
    }

    public void sampleMean(IReadDataBlock data, double expectedMean, TestType alternative) {
        DescriptiveStatistics bs = new DescriptiveStatistics(data);
        this.sampleMean(bs, expectedMean, alternative);
    }

    public void zeroMean(IReadDataBlock data) {
        DescriptiveStatistics bs = new DescriptiveStatistics(data);
        this.zeroMean(bs);
    }

    public void sampleMean(IReadDataBlock data, double expectedMean, double stdev, int nsample, TestType alternative) {
        DescriptiveStatistics bs = new DescriptiveStatistics(data);
        this.n_ = bs.getObservationsCount();
        this.mean_ = bs.getAverage();
        this.var_ = stdev * stdev;
        this.m_val = Math.sqrt(this.n_) * (this.mean_ - expectedMean) / stdev;
        T tstat = new T();
        tstat.setDegreesofFreedom(nsample - 1);
        this.m_dist = tstat;
        this.m_type = alternative;
        this.m_asympt = false;
        this.emean_ = expectedMean;
    }

    public static StatisticalTest compareVariances(MeanTest m0, MeanTest m1) {
        F f = new F();
        f.setDFNum(m1.getSampleSize() - 1);
        f.setDFDenom(m0.getSampleSize() - 1);
        return new StatisticalTest(f, m1.getVariance() / m0.getVariance(), TestType.TwoSided, false);
    }

    public static StatisticalTest compareMeans(MeanTest m0, MeanTest m1) {
        return MeanTest.compareMeans(m0, m1, !MeanTest.compareVariances(m0, m1).isSignificant());
    }

    public static StatisticalTest compareMeans(MeanTest m0, MeanTest m1, boolean samevar) {
        int df;
        double t;
        int n0 = m0.getSampleSize();
        int n1 = m1.getSampleSize();
        double v0 = m0.getVariance();
        double v1 = m1.getVariance();
        if (samevar) {
            double v = (v0 * (double)(n0 - 1) + v1 * (double)(n1 - 1)) / (double)(n0 + n1 - 2);
            t = (m1.getMean() - m0.getMean()) / Math.sqrt(v / (double)n0 + v / (double)n1);
            df = n0 + n1 - 2;
        } else {
            t = (m1.getMean() - m0.getMean()) / Math.sqrt(v0 / (double)n0 + v1 / (double)n1);
            df = Math.min(n0 - 1, n1 - 1);
        }
        T dist = new T();
        dist.setDegreesofFreedom(df);
        return new StatisticalTest(dist, t, TestType.TwoSided, false);
    }
}

