/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.FilteredData;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;
import ec.tstoolkit.ssf.VarianceFilter;

public abstract class BaseSmoother {
    ISsf m_ssf;
    ISsfData m_data;
    int m_pos;
    int m_r;
    DataBlock m_Rf;
    DataBlock m_Kf;
    double m_v;
    double m_ff;
    Matrix m_Nf;
    Matrix m_L;
    Matrix m_T;
    boolean m_bCalcVar = false;
    boolean m_bMissing;
    double m_c;
    double m_cvar;

    protected BaseSmoother() {
    }

    protected void clear() {
        this.m_data = null;
        this.m_Rf = null;
        this.m_Kf = null;
        this.m_Nf = null;
        this.m_L = null;
        this.m_T = null;
    }

    protected abstract FilteredData getFilteredData();

    public ISsf getSsf() {
        return this.m_ssf;
    }

    protected abstract VarianceFilter getVarianceFilter();

    protected void initSmoother() {
        this.m_pos = this.m_data.getCount() - 1;
        this.m_r = this.m_ssf.getStateDim();
        if (this.m_data.hasData()) {
            this.m_Rf = new DataBlock(this.m_r);
        }
        this.m_Kf = new DataBlock(this.m_r);
        if (this.m_bCalcVar) {
            this.m_Nf = new Matrix(this.m_r, this.m_r);
            this.m_L = new Matrix(this.m_r, this.m_r);
            this.m_T = new Matrix(this.m_r, this.m_r);
        }
    }

    public boolean isCalcVar() {
        return this.m_bCalcVar;
    }

    protected void iterateN() {
        if (!this.m_bMissing && this.m_ff != 0.0) {
            double vkv = SymmetricMatrix.quadraticForm(this.m_Nf, this.m_Kf);
            this.m_cvar = vkv + 1.0 / this.m_ff;
            DataBlockIterator nrows = this.m_Nf.rows();
            DataBlockIterator ncols = this.m_Nf.columns();
            DataBlock nrow = nrows.getData();
            DataBlock ncol = ncols.getData();
            do {
                this.m_ssf.XT(this.m_pos, nrow);
            } while (nrows.next());
            nrows.begin();
            DataBlock kvt = new DataBlock(this.m_r);
            do {
                kvt.set(ncols.getPosition(), this.m_Kf.dot(ncol));
                this.m_ssf.XT(this.m_pos, ncol);
            } while (ncols.next());
            ncols.begin();
            do {
                double k;
                if ((k = kvt.get(nrows.getPosition())) == 0.0) continue;
                this.m_ssf.XpZd(this.m_pos, nrow, -k);
                this.m_ssf.XpZd(this.m_pos, ncol, -k);
            } while (nrows.next() && ncols.next());
            this.m_ssf.VpZdZ(this.m_pos, this.m_Nf.subMatrix(), this.m_cvar);
            SymmetricMatrix.reinforceSymmetry(this.m_Nf);
        } else {
            DataBlockIterator nrows = this.m_Nf.rows();
            DataBlockIterator ncols = this.m_Nf.columns();
            DataBlock nrow = nrows.getData();
            DataBlock ncol = ncols.getData();
            do {
                this.m_ssf.XT(this.m_pos, nrow);
            } while (nrows.next());
            do {
                this.m_ssf.XT(this.m_pos, ncol);
            } while (ncols.next());
            SymmetricMatrix.reinforceSymmetry(this.m_Nf);
        }
    }

    protected void iterateR() {
        if (!this.m_bMissing && this.m_ff != 0.0) {
            this.m_c = this.m_v / this.m_ff - this.m_Rf.dot(this.m_Kf);
            this.m_ssf.XT(this.m_pos, this.m_Rf);
            this.m_ssf.XpZd(this.m_pos, this.m_Rf, this.m_c);
        } else {
            this.m_c = 0.0;
            this.m_ssf.XT(this.m_pos, this.m_Rf);
        }
    }

    protected void loadInfo() {
        this.m_bMissing = this.getVarianceFilter().isMissing(this.m_pos);
        this.m_ff = this.getVarianceFilter().F(this.m_pos);
        if (!this.m_bMissing && this.m_ff != 0.0) {
            this.m_v = this.getFilteredData().E(this.m_pos);
            this.m_Kf.copy(this.getVarianceFilter().C(this.m_pos));
            this.m_Kf.mul(1.0 / this.m_ff);
        } else {
            this.m_v = 0.0;
        }
    }

    protected void loadModelInfo() {
        if (this.m_T != null) {
            this.m_T.set(0.0);
            this.m_ssf.T(this.m_pos, this.m_T.subMatrix());
        }
    }

    public void setCalcVar(boolean value) {
        this.m_bCalcVar = value;
    }

    public void setSsf(ISsf value) {
        this.m_ssf = value;
        this.clear();
    }
}

