/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.levmar.LevenbergMarquardtMethod;
import ec.tstoolkit.modelling.arima.IModelEstimator;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.RegArimaEstimator;
import ec.tstoolkit.modelling.arima.x13.X13Preprocessor;
import ec.tstoolkit.sarima.SarimaModel;

public class X13Estimator
implements IModelEstimator {
    private double eps_ = 1.0E-7;

    public X13Estimator(double eps) {
        this.eps_ = eps;
    }

    @Override
    public boolean estimate(ModellingContext context) {
        IParametricMapping<SarimaModel> mapping = X13Preprocessor.createDefaultMapping(context.description);
        RegArimaEstimator monitor = new RegArimaEstimator(mapping);
        monitor.setMinimizer(new LevenbergMarquardtMethod());
        monitor.setPrecision(this.eps_);
        ModelEstimation estimation = new ModelEstimation(context.description.buildRegArima(), context.description.getLikelihoodCorrection());
        try {
            estimation.compute(monitor, mapping.getDim());
            estimation.updateParametersCovariance(monitor.getParametersCovariance());
            if (mapping.getDim() > 0) {
                context.information.subSet("optimization").set("score", monitor.getScore());
            }
            context.estimation = estimation;
            return true;
        }
        catch (RuntimeException err) {
            context.estimation = null;
            return false;
        }
    }
}

