/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.DerivedRegressionTest;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.IRegressionTest;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.SeparateRegressionTest;
import ec.tstoolkit.timeseries.regression.ICalendarVariable;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import java.util.ArrayList;

public class RegressionVariablesTest
implements IPreprocessingModule {
    public static final double CVAL = 1.96;
    public static final double F_PROB = 0.05;
    public static final double TSIG = 1.0;
    private IRegressionTest test_;
    private IRegressionTest mu_;
    private DerivedRegressionTest derived_;

    public RegressionVariablesTest(boolean join, double cval, boolean mu) {
        if (join) {
            this.test_ = new JointRegressionTest(0.05);
        } else {
            this.test_ = new SeparateRegressionTest(cval);
            this.derived_ = new DerivedRegressionTest(cval);
        }
        if (mu) {
            this.mu_ = new SeparateRegressionTest(cval);
        }
    }

    public RegressionVariablesTest(double cval) {
        this.test_ = new SeparateRegressionTest(cval);
        this.derived_ = new DerivedRegressionTest(cval);
    }

    public RegressionVariablesTest(double cval, double tsig) {
        this.test_ = new SeparateRegressionTest(cval);
        this.derived_ = new DerivedRegressionTest(cval);
        this.mu_ = new SeparateRegressionTest(tsig);
    }

    public void reset() {
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        Variable search;
        ConcentratedLikelihood ll = context.estimation.getLikelihood();
        boolean changed = false;
        int start = context.description.getRegressionVariablesStartingPosition();
        InformationSet tdsubset = context.information.subSet("calendar");
        InformationSet esubset = context.information.subSet("easter");
        TsVariableList x = context.description.buildRegressionVariables();
        TsVariableSelection<ITsVariable> sel = x.selectCompatible(ITradingDaysVariable.class);
        TsVariableSelection.Item<ITsVariable>[] items = sel.elements();
        int nregs = context.description.countRegressors(var -> var.status.isSelected() && var.getVariable() instanceof ICalendarVariable);
        int ntd = context.description.countRegressors(var -> var.status.isSelected() && var.getVariable() instanceof ITradingDaysVariable);
        boolean usetd = false;
        ArrayList<Variable> toreject = new ArrayList<Variable>();
        for (int i = 0; i < items.length; ++i) {
            Variable search2 = context.description.searchVariable((ITsVariable)items[i].variable);
            if (!search2.status.needTesting()) continue;
            if (!this.test_.accept(ll, -1, start + items[i].position, items[i].variable.getDim(), tdsubset) && (nregs <= 1 || this.derived_ != null && !this.derived_.accept(ll, -1, start, ntd, null))) {
                toreject.add(search2);
                continue;
            }
            usetd = true;
        }
        sel = x.selectCompatible(ILengthOfPeriodVariable.class);
        items = sel.elements();
        boolean uselp = false;
        for (int i = 0; i < items.length; ++i) {
            search = context.description.searchVariable((ITsVariable)items[i].variable);
            if (!search.status.needTesting()) continue;
            if (!this.test_.accept(ll, -1, start + items[i].position, items[i].variable.getDim(), tdsubset)) {
                toreject.add(search);
                continue;
            }
            uselp = true;
        }
        if (!(toreject.isEmpty() || uselp || usetd)) {
            changed = true;
            for (Variable var2 : toreject) {
                var2.status = RegStatus.Rejected;
            }
        }
        sel = x.selectCompatible(IMovingHolidayVariable.class);
        items = sel.elements();
        for (int i = 0; i < items.length; ++i) {
            search = context.description.searchVariable((ITsVariable)items[i].variable);
            if (!search.status.needTesting() || this.test_.accept(ll, -1, start + items[i].position, items[i].variable.getDim(), esubset)) continue;
            search.status = RegStatus.Rejected;
            changed = true;
        }
        if (this.mu_ != null && context.description.isEstimatedMean() && !this.mu_.accept(ll, -1, 0, 1, null)) {
            context.description.setMean(false);
            changed = true;
        }
        if (changed) {
            context.estimation = null;
            return ProcessingResult.Changed;
        }
        return ProcessingResult.Unchanged;
    }
}

