/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.arima.AICcComparator;
import ec.tstoolkit.modelling.arima.IModelComparator;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.RegArimaEstimator;
import ec.tstoolkit.modelling.arima.x13.X13Preprocessor;
import ec.tstoolkit.sarima.SarimaModel;

public class LogLevelTest
implements IPreprocessingModule {
    private final IModelComparator comparator_;
    private ModelEstimation level_;
    private ModelEstimation log_;
    private boolean adjust_ = true;
    private double eps_ = 1.0E-5;
    private static final String LOG_LEVEL = "Log/level test";
    private static final String LOGS = "Logs chosen";
    private static final String LEVELS = "Levels chosen";
    private static final String LOGS_TITLE = "Likelihood statistics for model fit to logs";
    private static final String LEVELS_TITLE = "Likelihood statistics for model fit to levels";

    public double getEpsilon() {
        return this.eps_;
    }

    public void setEpsilon(double val) {
        this.eps_ = val;
    }

    public LogLevelTest() {
        this.comparator_ = new AICcComparator(-2.0);
    }

    public LogLevelTest(double aicdiff) {
        this.comparator_ = new AICcComparator(aicdiff);
    }

    public boolean isChoosingLog() {
        if (this.log_ == null) {
            return false;
        }
        if (this.level_ == null) {
            return true;
        }
        return this.comparator_.compare(this.level_, this.log_) == 0;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        this.clear();
        this.addStartInfo(context);
        ModelDescription desc = context.description.clone();
        desc.setTransformation(DefaultTransformationType.None);
        ModelDescription ldesc = null;
        DescriptiveStatistics stats = new DescriptiveStatistics(context.description.getY());
        if (stats.isPositive()) {
            ldesc = context.description.clone();
            ldesc.setTransformation(DefaultTransformationType.Log);
        }
        IParametricMapping<SarimaModel> mapping = X13Preprocessor.createDefaultMapping(context.description);
        RegArimaEstimator monitor = new RegArimaEstimator(mapping);
        monitor.setPrecision(this.eps_);
        this.level_ = context.estimation;
        if (this.level_ == null) {
            try {
                this.level_ = new ModelEstimation(desc.buildRegArima(), desc.getLikelihoodCorrection());
                this.level_.compute(monitor, mapping.getDim());
            }
            catch (Exception err) {
                this.level_ = null;
            }
        }
        if (ldesc != null) {
            try {
                this.log_ = new ModelEstimation(ldesc.buildRegArima(), ldesc.getLikelihoodCorrection());
                this.log_.compute(monitor, mapping.getDim());
            }
            catch (Exception err) {
                this.log_ = null;
            }
        }
        if (this.comparator_.compare(this.log_, this.level_) == 0) {
            context.description = desc;
            context.estimation = this.level_;
        } else {
            context.description = ldesc;
            context.estimation = this.log_;
        }
        this.addInfo(context.information);
        this.addEndInfo(context);
        return ProcessingResult.Changed;
    }

    public DefaultTransformationType getTransformation() {
        return this.isChoosingLog() ? DefaultTransformationType.Log : DefaultTransformationType.None;
    }

    private void addInfo(InformationSet information) {
        InformationSet subset = information.subSet("transformation");
        if (this.level_ != null) {
            subset.set("level", Double.valueOf(this.level_.getStatistics().AICC));
        }
        if (this.log_ != null) {
            subset.set("log", Double.valueOf(this.log_.getStatistics().AICC));
        }
    }

    private void clear() {
        this.log_ = null;
        this.level_ = null;
    }

    private void addStartInfo(ModellingContext context) {
    }

    private void addEndInfo(ModellingContext context) {
    }

    private void addLogInfo(ModellingContext context) {
    }

    private void addLevelInfo(ModellingContext context) {
    }

    public ModelEstimation getLevel() {
        return this.level_;
    }

    public ModelEstimation getLog() {
        return this.log_;
    }
}

