/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.modelling.arima.ISeasonalityDetector;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.tramo.seriestest.OverSeasTest2;
import ec.tstoolkit.modelling.arima.tramo.seriestest.SerType;
import ec.tstoolkit.modelling.arima.tramo.spectrum.PeaksEnum;
import ec.tstoolkit.modelling.arima.tramo.spectrum.Spect;
import ec.tstoolkit.timeseries.simplets.TsData;

public class SeasonalityDetector2
implements ISeasonalityDetector {
    private static final double DEF_THRESHOLD = 6.0;
    private double threshold_ = 6.0;

    @Override
    public boolean hasSeasonality(ModelDescription desc) {
        TsData y = desc.transformedOriginal();
        if (!this.test1(y)) {
            return false;
        }
        int idiff = desc.getSpecification().getD() + desc.getSpecification().getBD();
        return this.test2(y, idiff);
    }

    private boolean test1(TsData y) {
        int n;
        TsData dy = y.delta(1);
        int ifreq = y.getFrequency().intValue();
        int nlag = 3 * ifreq;
        if (nlag >= (n = dy.getLength())) {
            nlag = 2 * ifreq;
        }
        if (nlag >= n) {
            return false;
        }
        double[] x = dy.internalStorage();
        double c0 = DescriptiveStatistics.cov(0, x);
        if (c0 == 0.0) {
            return false;
        }
        double qstat = 0.0;
        for (int i = 1; i <= nlag; ++i) {
            double acf = DescriptiveStatistics.cov(i, x) / c0;
            qstat += acf * acf / (double)(n - i);
        }
        return (qstat *= (double)(n * (n + 2))) > this.threshold_;
    }

    private boolean test2(TsData y, int idiff) {
        TsData d = y.delta(1);
        PeaksEnum[] peaks = Spect.SpectrumComputation(d);
        OverSeasTest2 seas = new OverSeasTest2(y, peaks, idiff, SerType.Xlin);
        return seas.getCheckOverSeasTest() != 0;
    }
}

