/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.arima.estimation.IRegArimaProcessor;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.IOutliersDetectionModule;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.timeseries.regression.SeasonalDummies;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;

public class DeterministicSeasonalityTest {
    private ModellingContext ds;
    private JointRegressionTest ftest;
    private final IOutliersDetectionModule outliers;
    private final IRegArimaProcessor<SarimaModel> processor;

    public DeterministicSeasonalityTest(IRegArimaProcessor<SarimaModel> processor, IOutliersDetectionModule outliers) {
        this.processor = processor;
        this.outliers = outliers;
    }

    public JointRegressionTest getTest() {
        return this.ftest;
    }

    public ModellingContext getTestedModellingContext() {
        return this.ds;
    }

    public boolean test(ModellingContext context) {
        RegArimaModel<SarimaModel> regarima;
        ModelEstimation estim;
        PreprocessingModel model = context.current(true);
        ModelDescription md = model.description.clone();
        SeasonalDummies sd = new SeasonalDummies(context.description.getEstimationDomain().getFrequency());
        Variable tvar = Variable.userVariable(sd, ComponentType.Seasonal, RegStatus.Prespecified);
        md.addVariable(tvar);
        SarimaSpecification spec = md.getSpecification();
        spec.setBP(0);
        spec.setBD(0);
        spec.setBQ(0);
        md.setSpecification(spec);
        this.ds = new ModellingContext();
        this.ds.description = md;
        if (this.outliers != null) {
            this.outliers.process(this.ds);
        }
        if (!(estim = new ModelEstimation(regarima = md.buildRegArima(), md.getLikelihoodCorrection())).compute(this.processor, spec.getParametersCount())) {
            return false;
        }
        this.ds.estimation = estim;
        TsVariableList ts = md.buildRegressionVariables();
        TsVariableSelection<SeasonalDummies> sel = ts.select(SeasonalDummies.class);
        this.ftest = new JointRegressionTest(0.05);
        this.ftest.accept(estim.getLikelihood(), this.ds.description.getArimaComponent().getParametersCount(), sel.get((int)0).position, sd.getDim(), null);
        return true;
    }
}

