/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.arima.IRegressionTest;

public class SeparateRegressionTest
implements IRegressionTest {
    private double tlow_;
    private double thigh_;
    private int nsig_;

    public SeparateRegressionTest(double tlow, double thigh) {
        this.tlow_ = tlow;
        this.thigh_ = thigh;
        this.nsig_ = 2;
    }

    public SeparateRegressionTest(double tsig) {
        this.tlow_ = tsig;
        this.thigh_ = tsig;
        this.nsig_ = 1;
    }

    @Override
    public boolean accept(ConcentratedLikelihood ll, int nhp, int ireg, int nregs, InformationSet info) {
        double[] t = ll.getTStats(nhp >= 0, nhp);
        int nlow = 0;
        int nhigh = 0;
        for (int i = 0; i < nregs; ++i) {
            double ct = Math.abs(t[ireg + i]);
            if (ct >= this.thigh_) {
                ++nhigh;
                continue;
            }
            if (!(ct >= this.tlow_)) continue;
            ++nlow;
        }
        return nhigh > 0 || nlow >= Math.min(this.nsig_, nregs);
    }
}

