/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices.lapack;

@Deprecated
public class Dlamch {
    private static final double ZERO = 0.0;
    private static final double ONE = 1.0;
    private static double g_eps;
    private static double g_sfmin;
    private static double g_base;
    private static double g_epsbase;
    private static double g_rmin;
    private static double g_rmax;
    private static int g_emin;
    private static int g_emax;
    private static int g_t;
    private static int g_beta;
    private static boolean g_ieee1;
    private static boolean g_rnd;

    private static void dlamc1() {
        double a = 1.0;
        double c = 1.0;
        while (c == 1.0) {
            a = 2.0 * a;
            c = Dlamch.dlamc3(a, 1.0);
            c = Dlamch.dlamc3(c, -a);
        }
        double b = 1.0;
        c = Dlamch.dlamc3(a, b);
        while (c == a) {
            c = Dlamch.dlamc3(a, b *= 2.0);
        }
        double qtr = 0.25;
        double savec = c;
        c = Dlamch.dlamc3(c, -a);
        int lbeta = (int)(c + qtr);
        b = lbeta;
        double f = Dlamch.dlamc3(b / 2.0, -b / 100.0);
        boolean lrnd = (c = Dlamch.dlamc3(f, a)) == a;
        f = Dlamch.dlamc3(b / 2.0, b / 100.0);
        c = Dlamch.dlamc3(f, a);
        if (lrnd && c == a) {
            lrnd = false;
        }
        double t1 = Dlamch.dlamc3(b / 2.0, a);
        double t2 = Dlamch.dlamc3(b / 2.0, savec);
        boolean lieee1 = t1 == a && t2 > savec && lrnd;
        int lt = 0;
        a = 1.0;
        c = 1.0;
        while (c == 1.0) {
            ++lt;
            c = Dlamch.dlamc3(a *= (double)lbeta, 1.0);
            c = Dlamch.dlamc3(c, -a);
        }
        g_beta = lbeta;
        g_t = lt;
        g_rnd = lrnd;
        g_ieee1 = lieee1;
    }

    private static void dlamc2() {
    }

    private static double dlamc3(double a, double b) {
        return a + b;
    }

    private static int dlamc4(double start, int base) {
        double a = start;
        double rbase = 1.0 / (double)base;
        int emin = 1;
        double b1 = Dlamch.dlamc3(a * rbase, 0.0);
        double c1 = a;
        double c2 = a;
        double d1 = a;
        double d2 = a;
        while (c1 == a && c2 == a && d1 == a && d2 == a) {
            --emin;
            a = b1;
            b1 = Dlamch.dlamc3(a / (double)base, 0.0);
            c1 = Dlamch.dlamc3(b1 * (double)base, 0.0);
            d1 = 0.0;
            for (int i = 0; i < base; ++i) {
                d1 += b1;
            }
            double b2 = Dlamch.dlamc3(a * rbase, 0.0);
            c2 = Dlamch.dlamc3(b2 / rbase, 0.0);
            d2 = 0.0;
            for (int i = 0; i < base; ++i) {
                d2 += b2;
            }
        }
        return emin;
    }

    private static void dlamc5(int p, boolean ieee) {
        int i;
        int uexp;
        g_emin = -3;
        g_emax = -g_emin;
        int lexp = 1;
        int exbits = 1;
        int etry = 2;
        while (etry <= -g_emin) {
            lexp = etry;
            ++exbits;
            etry = lexp * 2;
        }
        if (lexp == g_emin) {
            uexp = lexp;
        } else {
            uexp = etry;
            ++exbits;
        }
        int expsum = uexp + g_emin > -lexp - g_emin ? 2 * lexp : 2 * uexp;
        g_emax = expsum + g_emin - 1;
        int nbits = 1 + exbits + p;
        if (nbits % 2 == 1 && g_beta == 2) {
            --g_emax;
        }
        if (ieee) {
            --g_emax;
        }
        double recbas = 1.0 / (double)g_beta;
        double z = (double)g_beta - 1.0;
        double y = 0.0;
        double oldy = 0.0;
        for (i = 0; i < p; ++i) {
            z *= recbas;
            if (!(y < 1.0)) continue;
            oldy = y;
            y = Dlamch.dlamc3(y, z);
        }
        if (y >= 1.0) {
            y = oldy;
        }
        for (i = 0; i < g_emax; ++i) {
            y = Dlamch.dlamc3(y * (double)g_beta, 0.0);
        }
        g_rmax = y;
    }

    public static double EPS() {
        return g_eps;
    }

    public static double SFMIN() {
        return g_sfmin;
    }

    static {
        Dlamch.dlamc1();
        Dlamch.dlamc5(0, true);
    }
}

