/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.design.Algorithm;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.ForeFilter;
import ec.tstoolkit.maths.linearfilters.ISymmetricFilterDecomposer;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.maths.polynomials.LeastSquaresDivision;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.SymmetricMullerNewtonSolver;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.maths.polynomials.UnitRootsSolver;

@Algorithm(entryPoint="decompose")
public class SymmetricFrequencyResponseDecomposer3
implements ISymmetricFilterDecomposer {
    private double m_var;
    private BackFilter m_bf;
    private int m_freq;
    private double m_epsilon = 1.0E-4;
    private final double m_repsilon = 0.1;

    public SymmetricFrequencyResponseDecomposer3() {
        this.m_freq = 12;
    }

    public SymmetricFrequencyResponseDecomposer3(int freq) {
        this.m_freq = freq;
    }

    @Override
    public boolean decompose(SymmetricFilter sf) {
        try {
            SymmetricMullerNewtonSolver solver;
            UnitRoots ur;
            UnitRoots sur;
            double var = sf.getWeight(0);
            if (var <= 0.0) {
                return false;
            }
            SymmetricFilter cur = sf;
            this.m_bf = null;
            double[] weights = cur.getWeights();
            int i = 0;
            while (i < weights.length) {
                int n = i++;
                weights[n] = weights[n] / var;
            }
            UnitRootsSolver urs = new UnitRootsSolver(this.m_freq);
            Polynomial P = Polynomial.of(weights);
            if (urs.factorize(P) && (sur = (ur = urs.getUnitRoots()).sqrt()) != null) {
                Polynomial urp = sur.toPolynomial();
                Polynomial ur2 = urp.times(urp);
                this.m_bf = new BackFilter(urp);
                LeastSquaresDivision lsd = new LeastSquaresDivision();
                lsd.divide(P, ur2);
                P = lsd.getQuotient();
                double[] c = P.getCoefficients();
                int d = P.getDegree();
                int n = d / 2;
                for (int i2 = 0; i2 < n; ++i2) {
                    double q;
                    c[i2] = q = (c[i2] + c[d - i2]) / 2.0;
                    c[d - i2] = q;
                }
                P = Polynomial.of(c);
            }
            if (this.m_bf == null) {
                this.m_bf = BackFilter.ONE;
            }
            if (!(solver = new SymmetricMullerNewtonSolver()).factorize(P)) {
                return false;
            }
            Complex[] sroots = solver.getStableRoots();
            Polynomial P2 = Polynomial.fromComplexRoots(sroots);
            BackFilter bf = new BackFilter(P2);
            double v = bf.get(0);
            this.m_bf = bf.times(this.m_bf);
            this.m_bf = this.m_bf.normalize();
            Polynomial coeff = this.m_bf.getPolynomial();
            this.m_var = var / coeff.ssq();
            return this.m_var >= 0.0;
        }
        catch (Exception err) {
            return false;
        }
    }

    @Override
    public BackFilter getBFilter() {
        return this.m_bf;
    }

    @Override
    public double getFactor() {
        return this.m_var;
    }

    @Override
    public ForeFilter getFFilter() {
        return this.m_bf.mirror();
    }

    public double getPrecision() {
        return this.m_epsilon;
    }

    public int getStartingURValue() {
        return this.m_freq;
    }

    public void setPrecision(double value) {
        this.m_epsilon = value;
    }

    public void setStartingURValue(int value) {
        this.m_freq = value;
    }
}

