/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.design;

import ec.tstoolkit.design.GlobalServiceProvider;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"ec.tstoolkit.design.GlobalServiceProvider"})
public final class GlobalServiceProcessor
extends AbstractProcessor {
    private final Diagnostic.Kind kind = Diagnostic.Kind.ERROR;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager m = this.processingEnv.getMessager();
        for (Element element : roundEnv.getElementsAnnotatedWith(GlobalServiceProvider.class)) {
            if (element.getModifiers().contains((Object)Modifier.FINAL)) {
                m.printMessage(this.kind, "Cannot be final", element);
                continue;
            }
            Element method = this.getDefaultMethod((TypeElement)element);
            if (method == null) {
                m.printMessage(this.kind, "Missing method getDefault()", element);
                continue;
            }
            if (!method.getModifiers().contains((Object)Modifier.PUBLIC) || !method.getModifiers().contains((Object)Modifier.STATIC)) {
                m.printMessage(this.kind, "Default method must be public and static", element);
                continue;
            }
            ExecutableType t = (ExecutableType)method.asType();
            if (!t.getParameterTypes().isEmpty()) {
                m.printMessage(this.kind, "Default method requires no parameters", element);
                continue;
            }
            if (t.getReturnType().toString().equals(element.asType().toString())) continue;
            m.printMessage(this.kind, "Default method must return the annotated type", element);
        }
        return true;
    }

    private Element getDefaultMethod(TypeElement typeElement) {
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().toString().equals("getDefault")) continue;
            return element;
        }
        return null;
    }
}

