/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.DataBlock;

public final class DataBlockIterator
implements Cloneable {
    private final int bstart;
    private final int estart;
    private final int del;
    private final double[] data;
    private DataBlock cur;

    public DataBlockIterator(double[] data, int start, int nr, int nc, int rinc, int cinc) {
        this.data = data;
        this.bstart = start;
        this.estart = start + (nr - 1) * rinc;
        this.del = rinc;
        this.cur = new DataBlock(data, start, start + nc * cinc, cinc);
    }

    public DataBlockIterator clone() {
        try {
            DataBlockIterator iter = (DataBlockIterator)super.clone();
            iter.cur = this.cur.clone();
            return iter;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public void begin() {
        int cdel = this.cur.getStartPosition() - this.bstart;
        if (cdel > 0) {
            this.cur.slide(-cdel);
        }
    }

    public void end() {
        int cdel = this.estart - this.cur.beg;
        if (cdel != 0) {
            this.cur.slide(cdel);
        }
    }

    public int getCount() {
        return 1 + (this.del == 1 ? this.estart - this.bstart : (this.estart - this.bstart) / this.del);
    }

    public DataBlock getData() {
        return this.cur;
    }

    public int getPosition() {
        return (this.cur.beg - this.bstart) / this.del;
    }

    public boolean next() {
        if (this.cur.beg == this.estart) {
            return false;
        }
        this.cur.slide(this.del);
        return true;
    }

    public boolean previous() {
        if (this.cur.getStartPosition() != this.bstart) {
            this.cur.slide(-this.del);
            return true;
        }
        return false;
    }

    public void setPosition(int value) {
        int cdel = this.bstart + value * this.del - this.cur.getStartPosition();
        if (cdel != 0) {
            this.cur.slide(cdel);
        }
    }

    public DataBlock[] toArray() {
        DataBlock[] rc = new DataBlock[this.getCount()];
        int l = this.cur.getEndPosition() - this.cur.getStartPosition();
        int inc = this.cur.getIncrement();
        int i = 0;
        int b = this.bstart;
        while (i < rc.length) {
            rc[i] = new DataBlock(this.data, b, b + l, inc);
            ++i;
            b += this.del;
        }
        return rc;
    }

    public DataBlock sum() {
        DataBlockIterator tmp = this.clone();
        if (tmp.cur.beg == tmp.estart) {
            return null;
        }
        DataBlock sum = tmp.getData().deepClone();
        while (tmp.next()) {
            sum.add(tmp.getData());
        }
        return sum;
    }
}

