/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.ArmaFunction;
import ec.tstoolkit.arima.estimation.ConcentratedLikelihoodEstimation;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.DefaultLikelihoodEvaluation;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;

public class ArmaEvaluation<S extends IArimaModel>
implements ISsqFunctionInstance,
IFunctionInstance {
    final ArmaFunction<S> fn;
    final S arma;
    private DefaultLikelihoodEvaluation<ConcentratedLikelihood> m_ll;
    private boolean m_failed = false;

    public ArmaEvaluation(ArmaFunction<S> fn, S arma) {
        this.fn = fn;
        this.arma = arma;
    }

    private void calc() {
        ConcentratedLikelihoodEstimation cll = new ConcentratedLikelihoodEstimation(this.fn.filter);
        if (cll.estimate(this.fn.dmodel, this.fn.d, this.fn.missings, (IArimaModel)this.arma)) {
            this.m_ll = new DefaultLikelihoodEvaluation<ConcentratedLikelihood>(cll.getLikelihood());
            this.m_ll.useML(this.fn.ml);
            this.m_ll.useLogLikelihood(this.fn.llog);
        } else {
            this.m_failed = true;
        }
    }

    @Override
    public double[] getE() {
        if (this.m_ll == null && !this.m_failed) {
            this.calc();
        }
        return this.m_ll.getE();
    }

    public ConcentratedLikelihood getLikelihood() {
        if (this.m_ll == null && !this.m_failed) {
            this.calc();
        }
        return this.m_ll.getLikelihood();
    }

    @Override
    public IReadDataBlock getParameters() {
        return this.fn.mapper.map(this.arma);
    }

    @Override
    public double getSsqE() {
        if (this.m_ll == null && !this.m_failed) {
            this.calc();
        }
        return this.m_ll.getSsqValue();
    }

    @Override
    public double getValue() {
        if (this.m_ll == null && !this.m_failed) {
            this.calc();
        }
        return this.m_ll.getValue();
    }
}

