/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.SingleTsData;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;

public class SingleTsDataProcessing
implements IProcessing<TsData, SingleTsData> {
    public static final String SERIES = "series";
    private final TsPeriodSelector selector_;
    private Validation validation;

    @Override
    public SingleTsData process(TsData input) {
        TsData sinput = input;
        if (this.selector_ != null && this.selector_.getType() != PeriodSelectorType.All) {
            sinput = sinput.select(this.selector_);
        }
        if (this.validation != null && !this.validation.validate(sinput)) {
            return null;
        }
        return new SingleTsData(SERIES, sinput);
    }

    public SingleTsDataProcessing(TsPeriodSelector sel) {
        this.selector_ = sel;
    }

    public void setValidation(Validation val) {
        this.validation = val;
    }

    public Validation getValidation() {
        return this.validation;
    }

    public static interface Validation {
        public boolean validate(TsData var1);
    }
}

