/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.IEndPointsProcessor;
import ec.satoolkit.x11.SeasonalFilterOption;
import ec.tstoolkit.data.DataBlock;

public class MixedEndPoints
implements IEndPointsProcessor {
    private SeasonalFilterOption[] options;
    private int npoints;
    private int firstperiod;

    public MixedEndPoints(SeasonalFilterOption[] options, int npoints, int firstperiod) {
        this.options = options;
        this.npoints = npoints;
        this.firstperiod = firstperiod;
    }

    @Override
    public void process(DataBlock in, DataBlock out) {
        int n = out.getLength();
        int noptions = this.options.length;
        for (int i = 0; i < this.npoints; ++i) {
            int nperiodef = (i + this.firstperiod) % noptions;
            if (this.options[nperiodef] == SeasonalFilterOption.Stable) {
                out.set(i, out.get(i + noptions));
            } else {
                out.set(i, out.get(this.npoints));
            }
            int nperiodel = (n - this.npoints + this.firstperiod + i) % noptions;
            if (this.options[nperiodel] == SeasonalFilterOption.Stable) {
                out.set(n - this.npoints + i, out.get(n - this.npoints + i - noptions));
                continue;
            }
            out.set(n - this.npoints + i, out.get(n - this.npoints - 1));
        }
    }
}

