/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.IEndPointsProcessor;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;

public class FilteredMeanEndPoints
implements IEndPointsProcessor {
    private SymmetricFilter filter;

    public FilteredMeanEndPoints(SymmetricFilter filter) {
        this.filter = filter;
    }

    @Override
    public void process(DataBlock in, DataBlock out) {
        int len = this.filter.getLength() / 2;
        int n = in.getLength();
        double[] tmp = new double[n + 2 * len];
        in.copyTo(tmp, len);
        DataBlock rbeg = in.range(0, len);
        DataBlock rend = in.range(n - len, n);
        double beg = rbeg.sum() / (double)len;
        double end = rend.sum() / (double)len;
        int i = 0;
        int j = n + len;
        while (i < len) {
            tmp[i] = beg;
            tmp[j] = end;
            ++i;
            ++j;
        }
        this.filter.filter(new DataBlock(tmp), out);
    }
}

