/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.ComplexSeasonalFilteringStrategy;
import ec.satoolkit.x11.DefaultSeasonalFilteringStrategy;
import ec.satoolkit.x11.DefaultX11Algorithm;
import ec.satoolkit.x11.DummyFilter;
import ec.satoolkit.x11.FilterFactory;
import ec.satoolkit.x11.FilteredMeanEndPoints;
import ec.satoolkit.x11.IFiltering;
import ec.satoolkit.x11.ISeasonalComputer;
import ec.satoolkit.x11.MsrTable;
import ec.satoolkit.x11.SeasonalFilterFactory;
import ec.satoolkit.x11.SeasonalFilterOption;
import ec.satoolkit.x11.StableSeasonalFilteringStrategy;
import ec.satoolkit.x11.X11Step;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

class DefaultSeasonalComputer
extends DefaultX11Algorithm
implements ISeasonalComputer {
    private IFiltering initialFilter = SeasonalFilterFactory.getDefaultFilteringStrategy(SeasonalFilterOption.S3X3);
    private IFiltering finalFilter = SeasonalFilterFactory.getDefaultFilteringStrategy(SeasonalFilterOption.S3X5);
    private boolean useMsr = true;
    private DefaultSeasonalFilteringStrategy[] finalComplexSeasonalFilteringStrategy;

    DefaultSeasonalComputer() {
    }

    @Override
    public TsData doFinalFiltering(X11Step step, TsData s, InformationSet info) {
        IFiltering filtering = this.finalFilter == null ? new DummyFilter(this.context.isMultiplicative()) : (step != X11Step.D || !this.useMsr ? this.finalFilter : this.selectMsr(s, info));
        this.generateMsr(s, info);
        if (step == X11Step.D) {
            SymmetricFilter c = filtering.getCentralFilter();
            if (c != null) {
                info.subSet("d-tables").set("slen", Integer.valueOf(c.getLength()));
            }
            info.subSet("d-tables").set("d9filter", filtering.getDescription());
            if ("Composite filter".endsWith(filtering.getDescription())) {
                info.subSet("d-tables").set("d9filtercomposit", this.finalComplexSeasonalFilteringStrategy);
            }
        }
        return filtering.process(s, s.getDomain());
    }

    @Override
    public TsData doInitialFiltering(X11Step step, TsData s, InformationSet info) {
        TsDomain rdomain = s.getDomain();
        IFiltering filtering = this.initialFilter == null ? new DummyFilter(this.context.isMultiplicative()) : this.initialFilter;
        return filtering.process(s, rdomain);
    }

    private IFiltering selectMsr(TsData s, InformationSet info) {
        TsDomain rdomain = s.getDomain().drop(this.context.getBackcastHorizon(), this.context.getForecastHorizon());
        SymmetricFilter f7 = FilterFactory.makeSymmetricFilter(7);
        DefaultSeasonalFilteringStrategy fseas = new DefaultSeasonalFilteringStrategy(f7, new FilteredMeanEndPoints(f7));
        MsrTable rms = this.calculateMsr(fseas, rdomain, s);
        double grms = rms.getGlobalMsr();
        InformationSet dtables = info.subSet("d-tables");
        int ndrop = rdomain.getEnd().getPosition();
        if (ndrop != 0) {
            rdomain = rdomain.drop(0, ndrop);
            rms = this.calculateMsr(fseas, rdomain, s);
            grms = rms.getGlobalMsr();
        }
        int freq = this.context.getFrequency();
        IFiltering finalSeasonalFilter = null;
        if (!Double.isInfinite(grms)) {
            finalSeasonalFilter = SeasonalFilterFactory.getFilteringStrategyForGlobalRMS(grms);
        }
        int rmsrounds = 0;
        while (finalSeasonalFilter == null && rdomain.getLength() / freq >= 6) {
            ++rmsrounds;
            rdomain = rdomain.drop(0, freq);
            rms = this.calculateMsr(fseas, rdomain, s);
            grms = rms.getGlobalMsr();
            finalSeasonalFilter = SeasonalFilterFactory.getFilteringStrategyForGlobalRMS(grms);
        }
        if (finalSeasonalFilter == null) {
            finalSeasonalFilter = SeasonalFilterFactory.C_S3X5;
            dtables.set("s3x5default", Boolean.valueOf(true));
        }
        dtables.set("rmsRounds", Integer.valueOf(rmsrounds));
        return finalSeasonalFilter;
    }

    public void setFilter(SeasonalFilterOption option) {
        switch (option) {
            case X11Default: {
                this.setX11Filters();
                break;
            }
            case Msr: {
                this.setMsrFilters();
                break;
            }
            case Stable: {
                this.setStableFilter();
                break;
            }
            default: {
                this.useMsr = false;
                DefaultSeasonalFilteringStrategy s = SeasonalFilterFactory.getDefaultFilteringStrategy(option);
                this.initialFilter = s;
                this.finalFilter = s;
            }
        }
    }

    public void setFilters(SeasonalFilterOption[] options) {
        if (options == null) {
            this.setMsrFilters();
        } else if (options.length == 1 || this.allEqual(options)) {
            this.setFilter(options[0]);
        } else {
            this.useMsr = false;
            DefaultSeasonalFilteringStrategy[] s0 = new DefaultSeasonalFilteringStrategy[options.length];
            DefaultSeasonalFilteringStrategy[] s1 = new DefaultSeasonalFilteringStrategy[options.length];
            for (int i = 0; i < options.length; ++i) {
                DefaultSeasonalFilteringStrategy filter;
                if (options[i] == SeasonalFilterOption.Msr || options[i] == SeasonalFilterOption.X11Default) {
                    s0[i] = SeasonalFilterFactory.getDefaultFilteringStrategy(SeasonalFilterOption.S3X3);
                    s1[i] = SeasonalFilterFactory.getDefaultFilteringStrategy(SeasonalFilterOption.S3X5);
                    continue;
                }
                s0[i] = filter = SeasonalFilterFactory.getDefaultFilteringStrategy(options[i]);
                s1[i] = filter;
            }
            if (options.length != 1) {
                this.finalComplexSeasonalFilteringStrategy = s1;
            }
            this.initialFilter = new ComplexSeasonalFilteringStrategy(s0);
            this.finalFilter = new ComplexSeasonalFilteringStrategy(s1);
        }
    }

    public void setMsrFilters() {
        this.useMsr = true;
        this.initialFilter = SeasonalFilterFactory.getDefaultFilteringStrategy(SeasonalFilterOption.S3X3);
        this.finalFilter = SeasonalFilterFactory.getDefaultFilteringStrategy(SeasonalFilterOption.S3X5);
    }

    public void setDummyFilter() {
        this.useMsr = false;
        this.initialFilter = null;
        this.finalFilter = null;
    }

    public void setStableFilter() {
        this.useMsr = false;
        this.initialFilter = new StableSeasonalFilteringStrategy();
        this.finalFilter = new StableSeasonalFilteringStrategy();
    }

    public void setX11Filters() {
        this.useMsr = false;
        this.initialFilter = SeasonalFilterFactory.getDefaultFilteringStrategy(SeasonalFilterOption.S3X3);
        this.finalFilter = SeasonalFilterFactory.getDefaultFilteringStrategy(SeasonalFilterOption.S3X5);
    }

    private MsrTable calculateMsr(DefaultSeasonalFilteringStrategy fseas, TsDomain rdomain, TsData s) {
        TsData s1 = fseas.process(s, rdomain);
        TsData s2 = this.context.isPseudoAdditive() ? s.minus(s1).plus(1.0) : this.op(s, s1);
        return MsrTable.create(s1, s2, this.isMultiplicative());
    }

    private void generateMsr(TsData s, InformationSet info) {
        TsDomain rdomain = s.getDomain().drop(this.context.getBackcastHorizon(), this.context.getForecastHorizon());
        SymmetricFilter f7 = FilterFactory.makeSymmetricFilter(7);
        DefaultSeasonalFilteringStrategy fseas = new DefaultSeasonalFilteringStrategy(f7, new FilteredMeanEndPoints(f7));
        MsrTable rms = this.calculateMsr(fseas, rdomain, s);
        InformationSet dtables = info.subSet("d-tables");
        dtables.set("finalRMS", rms);
    }

    private boolean allEqual(SeasonalFilterOption[] options) {
        SeasonalFilterOption option1 = options[0];
        for (SeasonalFilterOption option : options) {
            if (option.equals((Object)option1)) continue;
            return false;
        }
        return true;
    }
}

