/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.satoolkit.seats.IComponentsEstimator;
import ec.satoolkit.seats.SeatsContext;
import ec.satoolkit.seats.SeatsModel;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.ssf.ExtendedSsfData;
import ec.tstoolkit.ssf.Smoother;
import ec.tstoolkit.ssf.SmoothingResults;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.ucarima.SsfUcarima;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.ucarima.UcarimaModel;

public class KalmanEstimator
implements IComponentsEstimator {
    private final int npred;

    private int nf(TsFrequency freq) {
        if (this.npred >= 0) {
            return this.npred;
        }
        return freq.intValue() * -this.npred;
    }

    public KalmanEstimator(int npred) {
        this.npred = npred;
    }

    @Override
    public DefaultSeriesDecomposition decompose(SeatsModel model, UcarimaModel ucm, InformationSet info, SeatsContext context) {
        DataBlock z;
        boolean hasirr;
        DefaultSeriesDecomposition decomposition = new DefaultSeriesDecomposition(DecompositionMode.Additive);
        TsData s = model.getSeries();
        int n = s.getLength();
        int nf = this.nf(s.getFrequency());
        TsDomain sdomain = s.getDomain();
        TsDomain fdomain = new TsDomain(s.getEnd(), nf);
        boolean hast = !ucm.getComponent(0).isNull() || model.isMeanCorrection();
        boolean hass = !ucm.getComponent(1).isNull();
        boolean hastr = !ucm.getComponent(2).isNull();
        boolean bl = hasirr = hastr || !ucm.getComponent(3).isNull();
        if (model.isMeanCorrection()) {
            UcarimaModel tmp = new UcarimaModel();
            ArimaModel tm = ucm.getComponent(0);
            BackFilter ur = BackFilter.D1;
            tm = tm.isNull() ? new ArimaModel(null, ur, ur, 0.0) : new ArimaModel(tm.getStationaryAR(), tm.getNonStationaryAR().times(ur), tm.getMA().times(ur), tm.getInnovationVariance());
            tmp.addComponent(tm);
            for (int i = 1; i < ucm.getComponentsCount(); ++i) {
                tmp.addComponent(ucm.getComponent(i));
            }
            ucm = tmp;
        } else {
            ucm = ucm.clone();
        }
        if (hastr) {
            ucm.compact(2, 2);
        }
        ucm.simplify();
        SsfData sdata = new SsfData(s.internalStorage(), null);
        ExtendedSsfData xsdata = new ExtendedSsfData(sdata);
        xsdata.setForecastsCount(nf);
        SsfUcarima ssf = new SsfUcarima(ucm);
        Smoother smoother = new Smoother();
        smoother.setSsf(ssf);
        smoother.setCalcVar(true);
        SmoothingResults srslts = new SmoothingResults();
        smoother.process(xsdata, srslts);
        srslts.setStandardError(model.getSer());
        TsData[] cmps = new TsData[ucm.getComponentsCount()];
        TsData[] fcmps = new TsData[ucm.getComponentsCount()];
        TsData[] ecmps = new TsData[ucm.getComponentsCount()];
        TsData[] efcmps = new TsData[ucm.getComponentsCount()];
        for (int i = 0; i < ucm.getComponentsCount(); ++i) {
            double[] tmp = srslts.component(ssf.cmpPos(i));
            TsData cur = new TsData(s.getStart(), tmp, false);
            cmps[i] = cur.fittoDomain(sdomain);
            fcmps[i] = cur.fittoDomain(fdomain);
            double[] etmp = srslts.componentStdev(ssf.cmpPos(i));
            TsData ecur = new TsData(s.getStart(), etmp, false);
            ecmps[i] = ecur.fittoDomain(sdomain);
            efcmps[i] = ecur.fittoDomain(fdomain);
        }
        DataBlock zsa = new DataBlock(ssf.getStateDim());
        int cur = 0;
        decomposition.add(s, ComponentType.Series);
        if (hast) {
            zsa.set(ssf.cmpPos(cur), 1.0);
            decomposition.add(cmps[cur], ComponentType.Trend);
            decomposition.add(fcmps[cur], ComponentType.Trend, ComponentInformation.Forecast);
            decomposition.add(ecmps[cur], ComponentType.Trend, ComponentInformation.Stdev);
            decomposition.add(efcmps[cur], ComponentType.Trend, ComponentInformation.StdevForecast);
            ++cur;
        }
        if (hass) {
            decomposition.add(cmps[cur], ComponentType.Seasonal);
            decomposition.add(fcmps[cur], ComponentType.Seasonal, ComponentInformation.Forecast);
            decomposition.add(ecmps[cur], ComponentType.Seasonal, ComponentInformation.Stdev);
            decomposition.add(efcmps[cur], ComponentType.Seasonal, ComponentInformation.StdevForecast);
            ++cur;
        }
        if (hasirr) {
            zsa.set(ssf.cmpPos(cur), 1.0);
            decomposition.add(cmps[cur], ComponentType.Irregular);
            decomposition.add(fcmps[cur], ComponentType.Irregular, ComponentInformation.Forecast);
            decomposition.add(ecmps[cur], ComponentType.Irregular, ComponentInformation.Stdev);
            decomposition.add(efcmps[cur], ComponentType.Irregular, ComponentInformation.StdevForecast);
        }
        if (hass) {
            z = new DataBlock(ssf.getStateDim());
            ssf.Z(0, z);
        } else {
            z = zsa;
        }
        double[] f = srslts.zcomponent(z);
        double[] ef = srslts.zvariance(z);
        TsData sf = new TsData(fdomain);
        TsData sef = new TsData(fdomain);
        for (int i = 0; i < fdomain.getLength(); ++i) {
            sf.set(i, f[n + i]);
            sef.set(i, ef[n + i] <= 0.0 ? 0.0 : Math.sqrt(ef[n + i]));
        }
        decomposition.add(sf, ComponentType.Series, ComponentInformation.Forecast);
        decomposition.add(sef, ComponentType.Series, ComponentInformation.StdevForecast);
        if (hass) {
            int is = hast ? 1 : 0;
            decomposition.add(TsData.subtract(s, cmps[is]), ComponentType.SeasonallyAdjusted);
            decomposition.add(ecmps[is], ComponentType.SeasonallyAdjusted, ComponentInformation.Stdev);
            double[] fsa = srslts.zcomponent(zsa);
            double[] efsa = srslts.zvariance(zsa);
            TsData sfsa = new TsData(fdomain);
            TsData sefsa = new TsData(fdomain);
            for (int i = 0; i < fdomain.getLength(); ++i) {
                sfsa.set(i, fsa[n + i]);
                sefsa.set(i, efsa[n + i] <= 0.0 ? 0.0 : Math.sqrt(efsa[n + i]));
            }
            decomposition.add(sfsa, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
            decomposition.add(sefsa, ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
        } else {
            decomposition.add(s, ComponentType.SeasonallyAdjusted);
            decomposition.add(sf, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
            decomposition.add(sef, ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast);
        }
        return decomposition;
    }
}

