/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.satoolkit.seats.IModelBuilder;
import ec.satoolkit.seats.SeatsContext;
import ec.satoolkit.seats.SeatsModel;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.sarima.SarimaComponent;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.timeseries.simplets.TsData;

public class DefaultModelBuilder
implements IModelBuilder {
    private SarimaComponent arima;

    public DefaultModelBuilder(SarimaComponent arima) {
        this.arima = arima;
    }

    @Override
    public SeatsModel build(TsData y, InformationSet info, SeatsContext context) {
        int ifreq = y.getFrequency().intValue();
        SarimaModel sarima = null;
        if (this.arima != null && this.arima.isDefined()) {
            this.arima.setS(ifreq);
            sarima = this.arima.getModel();
            return new SeatsModel(y, sarima, this.arima.isMean());
        }
        SarimaSpecification spec = null;
        boolean mean = false;
        if (this.arima == null) {
            spec = new SarimaSpecification(y.getFrequency().intValue());
            spec.airline();
        } else {
            spec = this.arima.getSpecification();
            spec.setFrequency(ifreq);
            mean = this.arima.isMean();
        }
        SeatsModel model = new SeatsModel(y, new SarimaModel(spec), mean);
        context.getEstimator().estimate(true, model, info);
        return model;
    }
}

