/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf.multivariate;

import ec.benchmarking.ssf.multivariate.Constraint;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.multivariate.AbstractMultivariateSsf;
import java.util.Collection;

public class MultivariateSsfDenton
extends AbstractMultivariateSsf {
    private int c_ = 4;
    private int nvars_;
    private double[][] w_;
    private Constraint[] constraints_;

    public MultivariateSsfDenton(int c, int nvars) {
        this.c_ = c;
        this.nvars_ = nvars;
    }

    public MultivariateSsfDenton(int c, Collection<double[]> weights) {
        this.c_ = c;
        if (weights != null) {
            this.w_ = new double[weights.size()][];
            this.w_ = (double[][])weights.toArray((T[])this.w_);
            this.nvars_ = weights.size();
        }
    }

    public MultivariateSsfDenton(int c, double[][] weights) {
        this.c_ = c;
        this.w_ = weights;
        this.nvars_ = weights.length;
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        int j = 1;
        int k = 0;
        while (j < 2 * this.nvars_) {
            b.set(j, k, 1.0);
            j += 2;
            ++k;
        }
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        for (int j = 1; j < 2 * this.nvars_; j += 2) {
            qm.set(j, j, 1.0);
        }
    }

    public int getConversionFactor() {
        return this.c_;
    }

    @Override
    public int getNonStationaryDim() {
        return this.nvars_;
    }

    @Override
    public int getStateDim() {
        return 2 * this.nvars_;
    }

    @Override
    public int getTransitionResCount() {
        return this.nvars_;
    }

    @Override
    public int getTransitionResDim() {
        return this.nvars_;
    }

    @Override
    public int getVarsCount() {
        return this.constraints_.length + this.nvars_;
    }

    @Override
    public boolean hasR() {
        return true;
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return true;
    }

    @Override
    public boolean hasW() {
        return false;
    }

    @Override
    public boolean hasZ(int pos, int v) {
        if (v < this.nvars_) {
            return (pos + 1) % this.c_ == 0;
        }
        return (pos + 1) % this.c_ != 0;
    }

    @Override
    public boolean isDiffuse() {
        return true;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.nvars_ > 0 && this.constraints_.length > 0;
    }

    @Override
    public void L(int pos, SubMatrix K, SubMatrix lm) {
        this.T(pos, lm);
        for (int i = 0; i < this.getVarsCount(); ++i) {
            DataBlockIterator rows = lm.rows();
            DataBlock row = rows.getData();
            do {
                double k = -K.get(rows.getPosition(), i);
                this.XpZd(pos, i, row, k);
            } while (rows.next());
        }
    }

    private double mweight(int pos, int v, double m) {
        return this.w_ == null ? m : this.w_[v][pos] * m;
    }

    @Override
    public void Pf0(SubMatrix pf0) {
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        for (int j = 1; j < 2 * this.nvars_; j += 2) {
            pi0.set(j, j, 1.0);
        }
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        qm.diagonal().set(1.0);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        int i = 0;
        int j = 1;
        while (i < this.nvars_) {
            rv.set(i, j);
            ++i;
            j += 2;
        }
    }

    public void setConstraints(Collection<Constraint> cnt) {
        this.constraints_ = new Constraint[cnt.size()];
        this.constraints_ = cnt.toArray(this.constraints_);
    }

    public void setConversionFactor(int value) {
        this.c_ = value;
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        tr.set(0.0);
        for (int i = 0; i < 2 * this.nvars_; i += 2) {
            tr.set(i + 1, i + 1, 1.0);
            if ((pos + 1) % this.c_ == 0) continue;
            tr.set(i, i + 1, this.weight(pos, i));
            if (pos % this.c_ == 0) continue;
            tr.set(i, i, 1.0);
        }
    }

    @Override
    public void TX(int pos, DataBlock x) {
        int i = 0;
        int j = 0;
        while (i < this.nvars_) {
            if ((pos + 1) % this.c_ != 0) {
                double s = x.get(j + 1);
                if (pos % this.c_ == 0) {
                    x.set(j, this.mweight(pos, i, s));
                } else {
                    x.add(j, this.mweight(pos, i, s));
                }
            } else {
                x.set(j, 0.0);
            }
            ++i;
            j += 2;
        }
    }

    @Override
    public void VpZdZ(int pos, int v, int w, SubMatrix vm, double d) {
        block7: {
            int iv;
            block6: {
                if (w < v) {
                    int t = v;
                    v = w;
                    w = t;
                }
                iv = 2 * v;
                int iw = 2 * w;
                if (w >= this.nvars_) break block6;
                double dv = this.weight(pos, v);
                double dw = this.weight(pos, w);
                vm.add(iv + 1, iw + 1, dv * d * dw);
                if ((pos + 1) % this.c_ != 0) break block7;
                vm.add(iv, iw, d);
                vm.add(iv, iw + 1, d * dw);
                vm.add(iv + 1, iw, d * dv);
                break block7;
            }
            if (v < this.nvars_) {
                Constraint wcnt = this.constraints_[w -= this.nvars_];
                double dv = this.weight(pos, v);
                for (int i = 0; i < wcnt.index.length; ++i) {
                    int l = wcnt.index[i];
                    int il = 2 * l;
                    double wl = wcnt.weights[i];
                    double dl = this.weight(pos, l);
                    double D = d * wl;
                    vm.add(iv + 1, il + 1, dv * D * dl);
                    if ((pos + 1) % this.c_ != 0) continue;
                    vm.add(iv, il + 1, D * dl);
                }
            } else {
                Constraint vcnt = this.constraints_[v -= this.nvars_];
                Constraint wcnt = this.constraints_[w -= this.nvars_];
                for (int i = 0; i < vcnt.index.length; ++i) {
                    int k = vcnt.index[i];
                    int ik = 2 * k;
                    double dk = this.mweight(pos, k, vcnt.weights[i]);
                    for (int j = 0; j < wcnt.index.length; ++j) {
                        int l = wcnt.index[j];
                        int il = 2 * l;
                        double dl = this.mweight(pos, l, wcnt.weights[j]);
                        vm.add(ik + 1, il + 1, d * dk * dl);
                    }
                }
            }
        }
    }

    @Override
    public void W(int pos, SubMatrix wv) {
    }

    private double weight(int pos, int v) {
        return this.w_ == null ? 1.0 : this.w_[v][pos];
    }

    @Override
    public void XpZd(int pos, int v, DataBlock x, double d) {
        if (v < this.nvars_) {
            int iv = 2 * v;
            x.add(iv + 1, this.mweight(pos, v, d));
            if ((pos + 1) % this.c_ == 0) {
                x.add(iv, d);
            }
        } else {
            Constraint cnt = this.constraints_[v -= this.nvars_];
            for (int i = 0; i < cnt.index.length; ++i) {
                int k = cnt.index[i];
                int ik = 2 * k;
                x.add(ik + 1, this.mweight(pos, k, cnt.weights[i] * d));
            }
        }
    }

    @Override
    public void XT(int pos, DataBlock x) {
        int i = 0;
        int j = 0;
        while (i < this.nvars_) {
            double x1;
            double x0;
            if ((pos + 1) % this.c_ == 0) {
                x.set(j, 0.0);
            } else if (pos % this.c_ == 0) {
                x0 = x.get(j);
                x1 = x.get(j + 1);
                x.set(j + 1, x1 + this.mweight(pos, i, x0));
                x.set(j, 0.0);
            } else {
                x0 = x.get(j);
                x1 = x.get(j + 1);
                x.set(j + 1, x1 + this.mweight(pos, i, x0));
            }
            ++i;
            j += 2;
        }
    }

    @Override
    public void Z(int pos, int v, DataBlock z) {
        z.set(0.0);
        if (v < this.nvars_) {
            int iv = 2 * v;
            if ((pos + 1) % this.c_ == 0) {
                z.set(iv, 1.0);
            }
            z.set(iv + 1, this.weight(pos, v));
        } else {
            int k = v - this.nvars_;
            Constraint cnt = this.constraints_[k];
            for (int i = 0; i < cnt.index.length; ++i) {
                int l = cnt.index[i];
                int il = 2 * l;
                z.set(il + 1, this.mweight(pos, l, cnt.weights[i]));
            }
        }
    }

    @Override
    public void ZM(int pos, int v, SubMatrix m, DataBlock x) {
        x.set(0.0);
        if (v < this.nvars_) {
            int iv = 2 * v;
            if ((pos + 1) % this.c_ == 0) {
                x.copy(m.row(iv));
            }
            x.addAY(this.weight(pos, v), m.row(iv + 1));
        } else {
            int k = v - this.nvars_;
            Constraint cnt = this.constraints_[k];
            for (int i = 0; i < cnt.index.length; ++i) {
                int l = cnt.index[i];
                int il = 2 * l;
                x.addAY(this.mweight(pos, l, cnt.weights[i]), m.row(il + 1));
            }
        }
    }

    @Override
    public double ZVZ(int pos, int v, int w, SubMatrix vm) {
        if (w < v) {
            int t = v;
            v = w;
            w = t;
        }
        int iv = 2 * v;
        int iw = 2 * w;
        if (w < this.nvars_) {
            double dv = this.weight(pos, v);
            double dw = this.weight(pos, w);
            double s = dv * vm.get(iv + 1, iw + 1) * dw;
            if ((pos + 1) % this.c_ == 0) {
                s += vm.get(iw, iv);
                s += dv * vm.get(iv + 1, iw);
                s += dw * vm.get(iv, iw + 1);
            }
            return s;
        }
        if (v < this.nvars_) {
            int k = w - this.nvars_;
            Constraint cnt = this.constraints_[k];
            double dv = this.weight(pos, v);
            double s = 0.0;
            for (int i = 0; i < cnt.index.length; ++i) {
                int l = cnt.index[i];
                int il = 2 * l;
                double wl = cnt.weights[i];
                double dl = this.weight(pos, l);
                double scur = dv * vm.get(iv + 1, il + 1) * dl;
                if ((pos + 1) % this.c_ == 0) {
                    scur += dl * vm.get(iv, il + 1);
                }
                s += scur * wl;
            }
            return s;
        }
        Constraint vcnt = this.constraints_[v -= this.nvars_];
        Constraint wcnt = this.constraints_[w -= this.nvars_];
        double s = 0.0;
        for (int i = 0; i < vcnt.index.length; ++i) {
            int k = vcnt.index[i];
            int ik = 2 * k;
            double dk = this.mweight(pos, k, vcnt.weights[i]);
            for (int j = 0; j < wcnt.index.length; ++j) {
                int l = wcnt.index[j];
                int il = 2 * l;
                double dl = this.mweight(pos, l, wcnt.weights[j]);
                s += dk * vm.get(ik + 1, il + 1) * dl;
            }
        }
        return s;
    }

    @Override
    public double ZX(int pos, int v, DataBlock x) {
        if (v < this.nvars_) {
            int iv = 2 * v;
            double r = (pos + 1) % this.c_ != 0 ? 0.0 : x.get(iv);
            return r + this.mweight(pos, v, x.get(iv + 1));
        }
        int k = v - this.nvars_;
        Constraint cnt = this.constraints_[k];
        double sum = 0.0;
        for (int i = 0; i < cnt.index.length; ++i) {
            int l = cnt.index[i];
            int il = 2 * l;
            sum += this.mweight(pos, l, x.get(il + 1) * cnt.weights[i]);
        }
        return sum;
    }
}

