/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jd2.workspace.io.IO;
import jd2.workspace.io.Stax;
import jd2.workspace.io.Xml;
import lombok.NonNull;

public final class Jaxb {
    public static @org.checkerframework.checker.nullness.qual.NonNull Unmarshaller createUnmarshaller(@org.checkerframework.checker.nullness.qual.NonNull Class<?> type) throws IOException {
        Objects.requireNonNull(type);
        try {
            return JAXBContext.newInstance((Class[])new Class[]{type}).createUnmarshaller();
        }
        catch (JAXBException ex) {
            throw new Xml.WrappedException((Exception)((Object)ex));
        }
    }

    public static @org.checkerframework.checker.nullness.qual.NonNull Unmarshaller createUnmarshaller(@org.checkerframework.checker.nullness.qual.NonNull JAXBContext context) throws IOException {
        Objects.requireNonNull(context);
        try {
            return context.createUnmarshaller();
        }
        catch (JAXBException ex) {
            throw new Xml.WrappedException((Exception)((Object)ex));
        }
    }

    private Jaxb() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Parser<T>
    implements Xml.Parser<T> {
        @NonNull
        private final IO.Supplier<? extends Unmarshaller> factory;
        private boolean preventXXE;
        @NonNull
        private final IO.Supplier<? extends XMLInputFactory> xxeFactory;

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Parser<T> of(@org.checkerframework.checker.nullness.qual.NonNull Class<T> type) throws IOException {
            Objects.requireNonNull(type);
            return Parser.builder().factory(() -> Jaxb.createUnmarshaller(type)).build();
        }

        public static <T> @org.checkerframework.checker.nullness.qual.NonNull Parser<T> of(@org.checkerframework.checker.nullness.qual.NonNull JAXBContext context) throws IOException {
            Objects.requireNonNull(context);
            return Parser.builder().factory(() -> Jaxb.createUnmarshaller(context)).build();
        }

        @Override
        public T parseFile(File source) throws IOException {
            Objects.requireNonNull(source);
            Unmarshaller engine = this.factory.getWithIO();
            return this.preventXXE ? Parser.parseFileXXE(engine, source, this.xxeFactory.getWithIO()) : Parser.parseFile(engine, source);
        }

        @Override
        public T parseReader(Reader resource) throws IOException {
            Objects.requireNonNull(resource);
            Unmarshaller engine = this.factory.getWithIO();
            return this.preventXXE ? Parser.parseReaderXXE(engine, resource, this.xxeFactory.getWithIO()) : Parser.parseReader(engine, resource);
        }

        @Override
        public T parseStream(InputStream resource) throws IOException {
            Objects.requireNonNull(resource);
            Unmarshaller engine = this.factory.getWithIO();
            return this.preventXXE ? Parser.parseStreamXXE(engine, resource, this.xxeFactory.getWithIO()) : Parser.parseStream(engine, resource);
        }

        private static XMLInputFactory getStaxFactory() {
            XMLInputFactory result = XMLInputFactory.newFactory();
            Stax.preventXXE(result);
            return result;
        }

        private static <T> T parseFile(Unmarshaller engine, File source) throws IOException {
            try {
                return (T)engine.unmarshal(source);
            }
            catch (JAXBException ex) {
                throw new Xml.WrappedException((Exception)((Object)ex));
            }
        }

        private static <T> T parseReader(Unmarshaller engine, Reader resource) throws IOException {
            try {
                return (T)engine.unmarshal(resource);
            }
            catch (JAXBException ex) {
                throw new Xml.WrappedException((Exception)((Object)ex));
            }
        }

        private static <T> T parseStream(Unmarshaller engine, InputStream resource) throws IOException {
            try {
                return (T)engine.unmarshal(resource);
            }
            catch (JAXBException ex) {
                throw new Xml.WrappedException((Exception)((Object)ex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        private static <T> T parseFileXXE(Unmarshaller engine, File source, XMLInputFactory xxe) throws IOException {
            try (FileInputStream resource = new FileInputStream(source);){
                Object object;
                XMLStreamReader reader = xxe.createXMLStreamReader(resource);
                try {
                    object = engine.unmarshal(reader);
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return (T)object;
            }
            catch (JAXBException | XMLStreamException ex) {
                throw new Xml.WrappedException((Exception)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static <T> T parseReaderXXE(Unmarshaller engine, Reader resource, XMLInputFactory xxe) throws IOException {
            try (XMLStreamReader reader = xxe.createXMLStreamReader(resource);){
                Object object = engine.unmarshal(reader);
                return (T)object;
            }
            catch (JAXBException | XMLStreamException ex) {
                throw new Xml.WrappedException((Exception)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static <T> T parseStreamXXE(Unmarshaller engine, InputStream resource, XMLInputFactory xxe) throws IOException {
            try (XMLStreamReader reader = xxe.createXMLStreamReader(resource);){
                Object object = engine.unmarshal(reader);
                return (T)object;
            }
            catch (JAXBException | XMLStreamException ex) {
                throw new Xml.WrappedException((Exception)ex);
            }
        }

        private static <T> boolean $default$preventXXE() {
            return true;
        }

        private static <T> IO.Supplier<? extends XMLInputFactory> $default$xxeFactory() {
            return Parser::getStaxFactory;
        }

        Parser(@NonNull IO.Supplier<? extends Unmarshaller> factory, boolean preventXXE, @NonNull IO.Supplier<? extends XMLInputFactory> xxeFactory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            if (xxeFactory == null) {
                throw new NullPointerException("xxeFactory is marked non-null but is null");
            }
            this.factory = factory;
            this.preventXXE = preventXXE;
            this.xxeFactory = xxeFactory;
        }

        public static <T> Builder<T> builder() {
            return new Builder();
        }

        public Builder<T> toBuilder() {
            return new Builder().factory(this.factory).preventXXE(this.preventXXE).xxeFactory(this.xxeFactory);
        }

        public static class Builder<T> {
            private IO.Supplier<? extends Unmarshaller> factory;
            private boolean preventXXE$set;
            private boolean preventXXE$value;
            private boolean xxeFactory$set;
            private IO.Supplier<? extends XMLInputFactory> xxeFactory$value;

            Builder() {
            }

            public Builder<T> factory(@NonNull IO.Supplier<? extends Unmarshaller> factory) {
                if (factory == null) {
                    throw new NullPointerException("factory is marked non-null but is null");
                }
                this.factory = factory;
                return this;
            }

            public Builder<T> preventXXE(boolean preventXXE) {
                this.preventXXE$value = preventXXE;
                this.preventXXE$set = true;
                return this;
            }

            public Builder<T> xxeFactory(@NonNull IO.Supplier<? extends XMLInputFactory> xxeFactory) {
                if (xxeFactory == null) {
                    throw new NullPointerException("xxeFactory is marked non-null but is null");
                }
                this.xxeFactory$value = xxeFactory;
                this.xxeFactory$set = true;
                return this;
            }

            public Parser<T> build() {
                boolean preventXXE$value = this.preventXXE$value;
                if (!this.preventXXE$set) {
                    preventXXE$value = Parser.$default$preventXXE();
                }
                IO.Supplier xxeFactory$value = this.xxeFactory$value;
                if (!this.xxeFactory$set) {
                    xxeFactory$value = Parser.$default$xxeFactory();
                }
                return new Parser(this.factory, preventXXE$value, xxeFactory$value);
            }

            public String toString() {
                return "Jaxb.Parser.Builder(factory=" + this.factory + ", preventXXE$value=" + this.preventXXE$value + ", xxeFactory$value=" + this.xxeFactory$value + ")";
            }
        }
    }
}

