/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import jd2.workspace.WorkspaceFamily;
import jd2.workspace.WorkspaceItem;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface Workspace
extends Closeable {
    public @NonNull String getName() throws IOException;

    public void setName(@NonNull String var1) throws IOException;

    public @NonNull Collection<WorkspaceFamily> getSupportedFamilies() throws IOException;

    public @NonNull Collection<WorkspaceItem> getItems() throws IOException;

    public @NonNull Object load(@NonNull WorkspaceItem var1) throws IOException;

    public void store(@NonNull WorkspaceItem var1, @NonNull Object var2) throws IOException;

    public void delete(@NonNull WorkspaceItem var1) throws IOException;

    default public void copyTo(@NonNull Workspace target) throws IOException {
        target.setName(this.getName());
        Collection<WorkspaceFamily> families = target.getSupportedFamilies();
        for (WorkspaceItem o : this.getItems()) {
            if (!families.contains(o.getFamily())) continue;
            target.store(o, this.load(o));
        }
    }
}

