/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.MatrixParameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.math.matrixAlgebra.Matrix;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class CorrelationMatrixStatistic
extends Statistic.Abstract
implements VariableListener {
    private static final String CORRELATION_MATRIX = "correlationMatrix";
    private final MatrixParameter matrix;
    private final double[][] correlation;
    private boolean corrKnown = false;
    private final boolean invert;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private static final String INVERT = "invert";

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getChild(MatrixParameter.class);
            if (matrixParameter.getColumnDimension() != matrixParameter.getRowDimension()) {
                throw new XMLParseException("Only square matrices can be converted to correlation matrices");
            }
            Boolean bl = false;
            if (xMLObject.hasAttribute(INVERT)) {
                bl = xMLObject.getBooleanAttribute(INVERT);
            }
            return new CorrelationMatrixStatistic(matrixParameter, bl);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(MatrixParameter.class), AttributeRule.newBooleanRule(INVERT, true)};
        }

        @Override
        public String getParserDescription() {
            return "This element returns a statistic that is the correlation matrix of the associated child statistic (potentially inverting the child statistic).";
        }

        @Override
        public Class getReturnType() {
            return CorrelationMatrixStatistic.class;
        }

        @Override
        public String getParserName() {
            return CorrelationMatrixStatistic.CORRELATION_MATRIX;
        }
    };

    public CorrelationMatrixStatistic(MatrixParameter matrixParameter, Boolean bl) {
        this.matrix = matrixParameter;
        this.invert = bl;
        this.correlation = new double[matrixParameter.getRowDimension()][matrixParameter.getColumnDimension()];
        matrixParameter.addParameterListener(this);
    }

    @Override
    public int getDimension() {
        return this.matrix.getDimension();
    }

    @Override
    public double getStatisticValue(int n) {
        int n2;
        if (!this.corrKnown) {
            double[][] dArray = this.matrix.getParameterAsMatrix();
            if (this.invert) {
                dArray = new Matrix(dArray).inverse().toComponents();
            }
            for (n2 = 0; n2 < dArray.length; ++n2) {
                this.correlation[n2][n2] = 1.0;
                for (int i = n2 + 1; i < dArray.length; ++i) {
                    double d;
                    this.correlation[n2][i] = d = dArray[n2][i] / Math.sqrt(dArray[n2][n2] * dArray[i][i]);
                    this.correlation[i][n2] = d;
                }
            }
            this.corrKnown = true;
        }
        int n3 = n / this.correlation.length;
        n2 = n - n3 * this.correlation.length;
        return this.correlation[n3][n2];
    }

    @Override
    public String getDimensionName(int n) {
        return this.getStatisticName() + "." + this.matrix.getDimensionName(n);
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.corrKnown = false;
    }
}

